package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.ListViewUrlBuilder;

import java.util.*;

public class ListViewLinkNode extends RenderNode
{
	private final String nodeContent;
	private String titleExpression;
	private String targetExpression;
	private String plainLink;

	@Override
	public List<String> collectVariables()
	{
		return Arrays.asList(titleExpression, targetExpression);
	}

	public ListViewLinkNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		List<String> parts = StringUtils.csvLineToList(StringUtils.getInnerString(nodeContent, "(", ")"));
		for (int i = parts.size() - 1; i >= 0; i--)
		{
			if (parts.get(i).trim().toLowerCase().startsWith("title="))
				titleExpression = StringUtils.substringAfter(parts.remove(i), "=");
			else if (parts.get(i).trim().toLowerCase().startsWith("newwindow="))
				targetExpression = StringUtils.substringAfter(parts.remove(i), "=");
			else if (parts.get(i).trim().toLowerCase().startsWith("plainlink="))
				plainLink = StringUtils.substringAfter(parts.remove(i), "=");
		}
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		ListViewUrlBuilder listViewBuilder = new ListViewUrlBuilder();
		for (RenderNode node : getNodes())
		{
			if (node instanceof IListViewLinkSubNode)
			{
				((IListViewLinkSubNode) node).apply(listViewBuilder, helper, currentLineNumber);
			}
			else if (node instanceof TextNode)
			{
				//allow text nodes but do not handle them, consider them sort of comment nodes
			}
			else
			{
				throw new UnsupportedOperationException("The node " + node.describe() + " can not be inside " + describe());
			}
		}
		String targetWindow = "";
		if (ObjectChecker.isNotEmptyOrNull(targetExpression))
		{
			if (ObjectChecker.isNotEmptyOrNull(renderer.evalConstantOrVar(targetExpression, helper, currentLineNumber, insideCreator(), this)))
				targetWindow = " target='_blank' ";
		}
		String link = listViewBuilder.toString();
		String titleValue = ObjectChecker.getFirstNotEmptyObj(renderer.evalConstantOrVar(titleExpression, helper, currentLineNumber, false, this),
				listViewBuilder.getEntityType(), "List View");
		if (isPlainLink())
			builder.append(link);
		else
			builder.append("<a href='").append(link).append("'").append(targetWindow).append(">").append(titleValue).append("</a>");
	}

	private boolean isPlainLink()
	{
		return ComplexRenderer.isTrue(plainLink);
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endlistviewlink");
	}
}
