package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.utilities.ObjectChecker;

public class TableCellNode extends PrefixSuffixCompositeNode
{
	public TableCellNode(String nodeContent)
	{
		super(nodeContent);
	}

	@Override
	public boolean shouldSubNodeEndThis(RenderNode subNode)
	{
		return subNode instanceof TableCellNode || subNode instanceof TableRowNode;
	}

	@Override
	protected Object prefix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return "\n<td>";
	}

	@Override
	protected Object suffix(RendererPropertyResolver helper, int currentLineNumber)
	{
		return "\n</td>";
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endcell");
	}
}
