package com.namasoft.common.hijri;

import java.io.Serializable;
import java.util.Date;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class HijriFormatter implements Serializable
{
	private String seperator;
	private Integer yearPosition;
	private Integer dayPosition;
	private Integer monthPosition;
	private Boolean pad;

	private HijriFormatter()
	{
		this("-", 2, 0, 1, true);
	}

	public HijriFormatter(String seperator, Integer yearPosition, Integer dayPosition, Integer monthPosition, Boolean pad)
	{
		super();
		this.seperator = seperator;
		this.yearPosition = yearPosition;
		this.dayPosition = dayPosition;
		this.monthPosition = monthPosition;
		this.pad = pad;
	}

	public Date parse(CmnHijrTable table, String s)
	{
		if (ObjectChecker.isEmptyOrNull(s))
			return null;
		String[] parts = s.split(getSeperator());
		int y = Integer.parseInt(parts[getYearPosition()].trim());
		int m = Integer.parseInt(parts[getMonthPosition()].trim());
		int d = Integer.parseInt(parts[getDayPosition()].trim());
		return table.toGregorian(new HijriDate(y, m, d));
	}

	public String format(CmnHijrTable table, Date d)
	{
		HijriDate hijri = table.fromGregorian(d);
		if (hijri == null)
			return "";
		int[] parts = new int[4];
		parts[getYearPosition()] = hijri.getY();
		parts[getMonthPosition()] = hijri.getM();
		parts[getDayPosition()] = hijri.getD();
		return new StringBuilder().append(pad(parts[0])).append(seperator).append(pad(parts[1])).append(seperator).append(pad(parts[2])).toString();
	}

	private String pad(int i)
	{
		String pad = getPad() && i < 10 ? "0" : "";
		return pad + i;
	}

	public String getSeperator()
	{
		return seperator;
	}

	public void setSeperator(String seperator)
	{
		this.seperator = seperator;
	}

	public Integer getYearPosition()
	{
		return yearPosition;
	}

	public void setYearPosition(Integer yearPosition)
	{
		this.yearPosition = yearPosition;
	}

	public Integer getDayPosition()
	{
		return dayPosition;
	}

	public void setDayPosition(Integer dayPosition)
	{
		this.dayPosition = dayPosition;
	}

	public Integer getMonthPosition()
	{
		return monthPosition;
	}

	public void setMonthPosition(Integer monthPosition)
	{
		this.monthPosition = monthPosition;
	}

	public Boolean getPad()
	{
		return pad;
	}

	public void setPad(Boolean pad)
	{
		this.pad = pad;
	}

}
