package com.namasoft.common.layout;

import com.namasoft.common.layout.edit.*;
import com.namasoft.common.layout.list.ListScreenLayout;
import com.namasoft.common.layout.search.SearcherScreenLayout;
import com.namasoft.common.preferences.IScreenLayout;

import java.io.Serializable;

@SuppressWarnings("serial")
public abstract class ScreenLayout implements Serializable, TitledID, IScreenLayout
{
	private String id;
	private NaMaText title;
	private Owner owner;
	private Boolean selectable = true;
	private transient String creationLoacation;
	private static boolean logCreationLocation = false;

	public ScreenLayout()
	{
		if (logCreationLocation)
			creationLoacation = LayoutCreatedAtSetter.calc();
	}

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	@Override
	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	public Owner getOwner()
	{
		return owner;
	}

	public void setOwner(Owner owner)
	{
		this.owner = owner;
	}

	@Override
	public LayoutType type()
	{
		if (getClass() == EditScreenLayout.class)
			return LayoutType.EDIT;
		if (getClass() == ListScreenLayout.class)
			return LayoutType.LIST;
		if (getClass() == SearcherScreenLayout.class)
			return LayoutType.SEARCHER;
		return null;
	}

	public Boolean getSelectable()
	{
		return selectable;
	}

	public void setSelectable(Boolean selectable)
	{
		this.selectable = selectable;
	}

	public String creationLoacation()
	{
		return creationLoacation;
	}

	public static void setLogCreationLocation(boolean logCreationLocation)
	{
		ScreenLayout.logCreationLocation = logCreationLocation;
	}

	public abstract <T extends ScreenLayout> T fetchMobileScreen();

	public String fetchOwnerType()
	{
		if (getOwner() == null)
			return null;
		return getOwner().getOwnerId();
	}

	public boolean shouldNotApplySystemModifiers()
	{
		return false;
	}
}
