package com.namasoft.common.layout;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.layout.edit.NaMaText;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ViewName implements Serializable, TitledID
{
	private String id;
	private Boolean selectable;
	private NaMaText title;
	private Owner owner;
	private LayoutType type;

	public ViewName(LayoutType type, String id, NaMaText title, Owner owner, Boolean selectable)
	{
		this.owner = owner;
		this.title = title;
		this.id = id;
		this.type = type;
		this.selectable = selectable;
	}

	public ViewName()
	{
	}

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	@Override
	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	public Owner getOwner()
	{
		return owner;
	}

	public void setOwner(Owner owner)
	{
		this.owner = owner;
	}

	public LayoutType getType()
	{
		return type;
	}

	public void setType(LayoutType type)
	{
		this.type = type;
	}

	public Boolean getSelectable()
	{
		return selectable;
	}

	public void setSelectable(Boolean selectable)
	{
		this.selectable = selectable;
	}

}
