package com.namasoft.common.layout.edit;

import com.fasterxml.jackson.annotation.*;
import com.namasoft.common.layout.list.crosstab.CrossTableBlock;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

@XmlRootElement
@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlSeeAlso({ EditScreenGrid.class, EditScreenGroup.class, EditScreenList.class, EditScreenActionsBlock.class, CrossTableBlock.class,
		EditScreenReport.class, EditScreenDashBoard.class, EditScreenEmbeddedEdit.class })
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "namaClassTypeId")
@JsonSubTypes({ @JsonSubTypes.Type(value = EditScreenGrid.class, name = "EditScreenGrid"),
		@JsonSubTypes.Type(value = EditScreenGroup.class, name = "EditScreenGroup"),
		@JsonSubTypes.Type(value = EditScreenList.class, name = "EditScreenList"),
		@JsonSubTypes.Type(value = EditScreenActionsBlock.class, name = "EditScreenActionsBlock"),
		@JsonSubTypes.Type(value = CrossTableBlock.class, name = "CrossTableBlock"),
		@JsonSubTypes.Type(value = EditScreenReport.class, name = "EditScreenReport"),
		@JsonSubTypes.Type(value = EditScreenBlock.class, name = "EditScreenBlock"),
		@JsonSubTypes.Type(value = EditScreenDashBoard.class, name = "EditScreenDashBoard"),
		@JsonSubTypes.Type(value = EditScreenEmbeddedEdit.class, name = "EditScreenEmbeddedEdit") })
public class EditScreenBlock implements Serializable, ShowableInQuickCreate
{
	private NaMaText title;
	private String fieldId;
	private boolean showInQuickCreate = true;
	private String iconCode;

	public NaMaText getTitle()
	{
		return title;
	}

	public EditScreenBlock title(NaMaText title)
	{
		setTitle(title);
		return this;
	}
	public void setTitle(NaMaText text)
	{
		this.title = text;
	}

	public String getFieldId()
	{
		return fieldId;
	}

	public void setFieldId(String fieldId)
	{
		this.fieldId = fieldId;
	}

	public EditScreenBlock field(String fieldId)
	{
		setFieldId(fieldId);
		return this;
	}

	public boolean isShowInQuickCreate()
	{
		return showInQuickCreate;
	}

	public void setShowInQuickCreate(boolean showInQuickCreate)
	{
		this.showInQuickCreate = showInQuickCreate;
	}

	public static EditScreenBlock discussions()
	{
		EditScreenBlock block = new EditScreenBlock();
		block.setFieldId("discussions");
		return block;
	}

	public boolean isDiscussionBlock()
	{
		return ObjectChecker.areEqual(getClass(), EditScreenBlock.class) && ObjectChecker.areEqual(getFieldId(), "discussions");
	}

	public boolean isEditScreenBlock()
	{
		return true;
	}

	public List<String> subFieldsIds()
	{
		return Collections.emptyList();
	}

	public String getIconCode()
	{
		return iconCode;
	}

	public void updateIconCodeIfNotEmpty(Object iconCode)
	{
		if (ObjectChecker.isEmptyOrNull(iconCode))
			return;
		setIconCode(ObjectChecker.toStringOrNull(iconCode));
	}

	public void setIconCode(String iconCode)
	{
		this.iconCode = iconCode;
	}
}
