package com.namasoft.common.layout.edit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.namasoft.common.constants.Language;
import com.namasoft.common.layout.TitledID;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
public class EditScreenGridColumn implements Serializable, TitledID
{
	private String id;
	private String width;
	private NaMaText title;
	private boolean showInFullView = true;
	private boolean showInGridView = true;
	private Language showOnlyInLang;

	public Language getShowOnlyInLang()
	{
		return showOnlyInLang;
	}

	public void setShowOnlyInLang(Language showOnlyInLang)
	{
		this.showOnlyInLang = showOnlyInLang;
	}

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getWidth()
	{
		return width;
	}

	public void setWidth(String width)
	{
		this.width = width;
	}

	@Override
	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText text)
	{
		this.title = text;
	}

	public EditScreenGridColumn field(String id)
	{
		if (ObjectChecker.isNotEmptyOrNull(id) && Character.isDigit(id.charAt(0)))
			throw new RuntimeException("The id " + id + " seems to be a size not a column id, please review");
		setId(id);
		return this;
	}

	public EditScreenGridColumn width(String width)
	{
		setWidth(width);
		return this;
	}

	public EditScreenGridColumn title(NaMaText text)
	{
		setTitle(text);
		return this;
	}

	public static List<EditScreenGridColumn> of(String... ids)
	{
		List<EditScreenGridColumn> list = new ArrayList<EditScreenGridColumn>();
		for (String id : ids)
		{
			list.add(ofId(id));
		}
		return list;
	}

	public static EditScreenGridColumn guiField(String id)
	{
		EditScreenGridColumn column = ofId(id);
		return column;
	}

	public static EditScreenGridColumn ofId(String id)
	{
		return new EditScreenGridColumn().field(id);
	}

	public boolean isShowInFullView()
	{
		return showInFullView;
	}

	public void setShowInFullView(boolean showInFullView)
	{
		this.showInFullView = showInFullView;
	}

	public boolean isShowInGridView()
	{
		return showInGridView;
	}

	public void setShowInGridView(boolean showInGridView)
	{
		this.showInGridView = showInGridView;
	}

	public EditScreenGridColumn showInFull()
	{
		setShowInFullView(true);
		return this;
	}

	public EditScreenGridColumn showInGrid()
	{
		setShowInGridView(true);
		return this;
	}

	public EditScreenGridColumn showInBoth()
	{
		return showInFull().showInGrid();
	}

	public EditScreenGridColumn hideInFull()
	{
		setShowInFullView(false);
		return this;
	}

	public EditScreenGridColumn hideInGrid()
	{
		setShowInGridView(false);
		return this;
	}

	public EditScreenGridColumn hideInBoth()
	{
		return hideInFull().hideInGrid();
	}

	public EditScreenGridColumn cloneData()
	{
		EditScreenGridColumn newColumn = new EditScreenGridColumn();
		newColumn.setId(getId());
		newColumn.setShowInFullView(isShowInFullView());
		newColumn.setShowInGridView(isShowInGridView());
		newColumn.setTitle(getTitle());
		newColumn.setWidth(getWidth());
		return newColumn;
	}

	public EditScreenGridColumn showOnlyInArabic()
	{
		setShowOnlyInLang(Language.Arabic);
		return this;
	}

	public EditScreenGridColumn showOnlyInEnglish()
	{
		setShowOnlyInLang(Language.English);
		return this;
	}
}
