package com.namasoft.common.layout.list;

import com.namasoft.common.HasIDUtil;
import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.layout.*;
import com.namasoft.common.layout.metadata.BasicFieldMetaData;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.util.*;
import java.util.function.Function;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class AbsListScreen extends ScreenLayout implements HasQuestionFields, HasCriteriaFields, HasDimensionIds, TitledID
{
	private ListScreenToTimelineConfig listToTimeline;
	private Boolean supportsTimeline;
	private Boolean showTimelineByDefault;
	private Boolean horizontalTimeline = true;
	private List<ListScreenColumn> displayColumns = new ArrayList<ListScreenColumn>();
	private List<ListScreenColumn> quickFilterFieldsMetadata;
	private String defaultOrderBy;
	private List<CriteriaField> criteriaFields = new ArrayList<CriteriaField>();
	private String defaultSortType;
	private ListScreenType type;
	private String queriedClass;
	private DTOListViewQuery query;
	private String legalEntityId = null;
	private String sectorId = null;
	private String branchId = null;
	private String departmentId = null;
	private String analysisSetId = null;
	private Boolean doNotAddExtraCriteria;
	private String crieriaPrefix;
	private String objectName;
	private String runCustomActionsOn;
	private List<QuestionField> questionFields = new ArrayList<QuestionField>();
	private List<String> scripts = new ArrayList<>();
	private DTOCriteria defaultCriteria;
	private boolean addDefaultSortColumns = true;
	private boolean allowPaging = true;
	private String searchContextCriteriaPrefix;
	private Integer maxRecordCount;
	private List<ListViewQuickFilterDef> quickFilterGroups;

	public static List<String> calcProperties(List<ListScreenColumn> displayColumns)
	{
		List<String> properties = new ArrayList<>();
		calcProperties(properties, displayColumns);
		return properties;
	}

	public static void calcProperties(List<String> properties, List<ListScreenColumn> displayColumns)
	{
		for (ListScreenColumn column : displayColumns)
		{
			if (properties.contains(column.calculateSourceColumn()))
				continue;
			if (ObjectChecker.areEqual(column.getColumnType(), SystemListColumnType.Template))
				continue;
			properties.add(column.calculateSourceColumn());
		}
	}

	public ListScreenColumn getDisplayColumn(String id)
	{
		return HasIDUtil.find(id, getDisplayColumns());
	}

	public Boolean getSupportsTimeline()
	{
		return supportsTimeline;
	}

	public void setSupportsTimeline(Boolean supportsTimeline)
	{
		this.supportsTimeline = supportsTimeline;
	}

	public Boolean getShowTimelineByDefault()
	{
		return showTimelineByDefault;
	}

	public void setShowTimelineByDefault(Boolean showTimelineByDefault)
	{
		this.showTimelineByDefault = showTimelineByDefault;
	}

	public Boolean getHorizontalTimeline()
	{
		return horizontalTimeline;
	}

	public void setHorizontalTimeline(Boolean horizontalTimeline)
	{
		this.horizontalTimeline = horizontalTimeline;
	}

	@XmlElementWrapper(name = "displayColumns")
	@XmlElement(name = "displayColumn")
	public List<ListScreenColumn> getDisplayColumns()
	{
		return displayColumns;
	}

	public void setDisplayColumns(List<ListScreenColumn> displayColumns)
	{
		this.displayColumns = displayColumns;
	}

	public String getDefaultOrderBy()
	{
		return defaultOrderBy;
	}

	public void setDefaultOrderBy(String defaultOrderBy)
	{
		this.defaultOrderBy = defaultOrderBy;
	}

	public List<ListScreenColumn> getQuickFilterFieldsMetadata()
	{
		return quickFilterFieldsMetadata;
	}

	@XmlElementWrapper(name = "quickFilterFieldsMetadata")
	@XmlElement(name = "quickFilterField")
	public void setQuickFilterFieldsMetadata(List<ListScreenColumn> quickFilterFieldsMetadata)
	{
		this.quickFilterFieldsMetadata = quickFilterFieldsMetadata;
	}

	@XmlElementWrapper(name = "criteriaFields")
	@XmlElement(name = "criteriaField")
	public List<CriteriaField> getCriteriaFields()
	{
		return criteriaFields;
	}

	public void setCriteriaFields(List<CriteriaField> criteriaFields)
	{
		this.criteriaFields = criteriaFields;
	}

	public String getDefaultSortType()
	{
		return defaultSortType;
	}

	public void setDefaultSortType(String defaultSortType)
	{
		this.defaultSortType = defaultSortType;
	}

	public ListScreenType getType()
	{
		return type == null ? ListScreenType.Properties : type;
	}

	public void setType(ListScreenType type)
	{
		this.type = type;
	}

	@Override
	public String getQueriedClass()
	{
		return queriedClass;
	}

	public void setQueriedClass(String queriedClass)
	{
		this.queriedClass = queriedClass;
	}

	public DTOListViewQuery getQuery()
	{
		return query;
	}

	public void setQuery(DTOListViewQuery query)
	{
		this.query = query;
	}

	@Override
	public String getLegalEntityId()
	{
		return legalEntityId;
	}

	public void setLegalEntityId(String legalEntityId)
	{
		this.legalEntityId = legalEntityId;
	}

	@Override
	public String getSectorId()
	{
		return sectorId;
	}

	public void setSectorId(String sectorId)
	{
		this.sectorId = sectorId;
	}

	@Override
	public String getBranchId()
	{
		return branchId;
	}

	public void setBranchId(String branchId)
	{
		this.branchId = branchId;
	}

	@Override
	public String getDepartmentId()
	{
		return departmentId;
	}

	public void setDepartmentId(String departmentId)
	{
		this.departmentId = departmentId;
	}

	@Override
	public String getAnalysisSetId()
	{
		return analysisSetId;
	}

	public void setAnalysisSetId(String analysisSetId)
	{
		this.analysisSetId = analysisSetId;
	}

	@Override
	public Boolean getDoNotAddExtraCriteria()
	{
		return doNotAddExtraCriteria;
	}

	public void setDoNotAddExtraCriteria(Boolean doNotAddExtraCriteria)
	{
		this.doNotAddExtraCriteria = doNotAddExtraCriteria;
	}

	public String getCrieriaPrefix()
	{
		return crieriaPrefix;
	}

	public void setCrieriaPrefix(String crieriaPrefix)
	{
		this.crieriaPrefix = crieriaPrefix;
	}

	public String getObjectName()
	{
		return objectName;
	}

	public String getRunCustomActionsOn()
	{
		return runCustomActionsOn;
	}

	public void setRunCustomActionsOn(String runCustomActionsOn)
	{
		this.runCustomActionsOn = runCustomActionsOn;
	}

	public void setObjectName(String objectName)
	{
		this.objectName = objectName;
	}

	@XmlElementWrapper(name = "questionFields")
	@XmlElement(name = "questionField")
	@Override
	public List<QuestionField> getQuestionFields()
	{
		return questionFields;
	}

	@Override
	public void setQuestionFields(List<QuestionField> questionFields)
	{
		this.questionFields = questionFields;
	}

	@XmlElementWrapper(name = "scripts")
	@XmlElement(name = "script")
	public List<String> getScripts()
	{
		return scripts;
	}

	public void setScripts(List<String> scriptSources)
	{
		this.scripts = scriptSources;
	}

	public DTOCriteria getDefaultCriteria()
	{
		return defaultCriteria;
	}

	public void setDefaultCriteria(DTOCriteria defaultCriteria)
	{
		this.defaultCriteria = defaultCriteria;
	}

	@Override
	public QuestionField getQuestionField(String id)
	{
		return HasIDUtil.find(id, getQuestionFields());
	}

	@Override
	public CriteriaField getCriteriaField(String id)
	{
		return HasIDUtil.find(id, getCriteriaFields());
	}

	public boolean isAddDefaultSortColumns()
	{
		return addDefaultSortColumns;
	}

	public boolean isAllowPaging()
	{
		return allowPaging;
	}

	public void setAllowPaging(boolean allowPaging)
	{
		this.allowPaging = allowPaging;
	}

	public void setAddDefaultSortColumns(boolean addDefaultSortColumns)
	{
		this.addDefaultSortColumns = addDefaultSortColumns;
	}

	public abstract List<String> fetchSortColumnIds();

	public abstract List<String> fetchProperties();

	protected AbsListScreen objectBased(Class<?> objectClass, String objectName)
	{
		setObjectName(objectName);
		setQueriedClass(objectClass.getName());
		setSelectable(false);
		setType(ListScreenType.QueryObjectBased);
		return this;
	}

	protected AbsListScreen oql(String oql)
	{
		if (getType() != ListScreenType.QueryObjectBased)
			setType(ListScreenType.Query);
		setQuery(new DTOListViewQuery());
		setSelectable(false);
		getQuery().setType(QueryTypes.OQL);
		getQuery().setQuery(oql);
		return this;
	}

	public void setSearchContextCriteriaPrefix(String searchContextCriteriaPrefix)
	{
		this.searchContextCriteriaPrefix = searchContextCriteriaPrefix;
	}

	public String getSearchContextCriteriaPrefix()
	{
		return searchContextCriteriaPrefix;
	}

	protected void prefixEveryThing(String prefix, Function<ListScreenColumn, ListScreenColumn> cloner)
	{
		List<ListScreenColumn> columns = new ArrayList<>(getDisplayColumns());
		if (ObjectChecker.isNotEmptyOrNull(getDefaultOrderBy()))
			setDefaultOrderBy(prefix + "." + getDefaultOrderBy());
		for (ListScreenColumn column : columns)
		{
			if (ObjectChecker.isNotEmptyOrNull(column.getSourceColumn()))
				column.setSourceColumn(prefix + "." + column.getSourceColumn());
			if (ObjectChecker.isNotEmptyOrNull(column.getSources()))
			{
				for (int i = 0; i < column.getSources().size(); i++)
				{
					column.getSources().set(i, prefix + "." + column.getSources().get(i));
				}
			}
			if (ObjectChecker.isAnyNotEmptyOrNull(column.getSourceColumn(), column.getSources()))
				continue;
			ListScreenColumn clone = cloner.apply(column);
			clone.setId(prefix + "." + column.getId());
			clone.setDisplayed(false);
			clone.setRequired(true);
			column.setSourceColumn(clone.getId());
			getDisplayColumns().add(clone);
		}
		for (CriteriaField criteriaField : getCriteriaFields())
		{
			criteriaField.setId(prefix + "." + criteriaField.getId());
		}
	}

	public Integer getMaxRecordCount()
	{
		return maxRecordCount;
	}

	public void setMaxRecordCount(Integer maxRecordCount)
	{
		this.maxRecordCount = maxRecordCount;
	}

	public ListScreenToTimelineConfig getListToTimeline()
	{
		return listToTimeline;
	}

	public void setListToTimeline(ListScreenToTimelineConfig listToTimeline)
	{
		this.listToTimeline = listToTimeline;
	}

	public BasicFieldMetaData findMetadata(String c)
	{
		ListScreenColumn displayColumn = getDisplayColumn(c);
		if (displayColumn != null)
			return displayColumn.getMetaData();
		ListScreenColumn quickFilterColumn = HasIDUtil.find(c, getQuickFilterFieldsMetadata());
		if (quickFilterColumn != null)
			return quickFilterColumn.getMetaData();
		return null;
	}

	public List<ListViewQuickFilterDef> getQuickFilterGroups()
	{
		return quickFilterGroups;
	}

	public void setQuickFilterGroups(List<ListViewQuickFilterDef> quickFilterGroups)
	{
		this.quickFilterGroups = quickFilterGroups;
	}

	public ListViewQuickFilterDef addQuickFilterGroup(String... fields)
	{
		if (getQuickFilterGroups() == null)
			setQuickFilterGroups(new ArrayList<>());
		ListViewQuickFilterDef g = ListViewQuickFilterDef.create().addColumnNames(fields).showCount(true);
		getQuickFilterGroups().add(g);
		return g;
	}
}
