package com.namasoft.common.layout.list;

import com.namasoft.common.layout.edit.NaMaText;
import jakarta.xml.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class ListViewQuickFilterDef implements Serializable
{
	private NaMaText title;
	private Boolean showCount;
	private Boolean countDependOnOtherQuickFilters;
	private Integer maxButtonCount;
	private List<String> columnNames;
	private Boolean columnValuesDependOnOtherQuickFilters;
	private List<ListViewQuickFilterCriteriaDef> criteriaList;

	public static ListViewQuickFilterDef create()
	{
		return new ListViewQuickFilterDef();
	}

	public NaMaText getTitle()
	{
		return title;
	}

	public void setTitle(NaMaText title)
	{
		this.title = title;
	}

	public Boolean getShowCount()
	{
		return showCount;
	}

	public void setShowCount(Boolean showCount)
	{
		this.showCount = showCount;
	}

	public Boolean getCountDependOnOtherQuickFilters()
	{
		return countDependOnOtherQuickFilters;
	}

	public void setCountDependOnOtherQuickFilters(Boolean countDependOnOtherQuickFilters)
	{
		this.countDependOnOtherQuickFilters = countDependOnOtherQuickFilters;
	}

	public Integer getMaxButtonCount()
	{
		return maxButtonCount;
	}

	public void setMaxButtonCount(Integer maxButtonCount)
	{
		this.maxButtonCount = maxButtonCount;
	}

	public List<String> getColumnNames()
	{
		return columnNames;
	}

	public void setColumnNames(List<String> columnNames)
	{
		this.columnNames = columnNames;
	}

	public Boolean getColumnValuesDependOnOtherQuickFilters()
	{
		return columnValuesDependOnOtherQuickFilters;
	}

	public void setColumnValuesDependOnOtherQuickFilters(Boolean columnValuesDependOnOtherQuickFilters)
	{
		this.columnValuesDependOnOtherQuickFilters = columnValuesDependOnOtherQuickFilters;
	}

	public List<ListViewQuickFilterCriteriaDef> getCriteriaList()
	{
		return criteriaList;
	}

	public void setCriteriaList(List<ListViewQuickFilterCriteriaDef> criteriaList)
	{
		this.criteriaList = criteriaList;
	}

	public ListViewQuickFilterDef addColumnNames(String... fields)
	{
		if (getColumnNames() == null)
			setColumnNames(new ArrayList<>());
		getColumnNames().addAll(List.of(fields));
		return this;
	}

	public ListViewQuickFilterDef showCount(boolean showCount)
	{
		setShowCount(showCount);
		return this;
	}
}
