package com.namasoft.common.layout.metadata;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.NaMaError;
import com.namasoft.common.hijri.*;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.math.BigDecimal;
import java.util.*;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CustomGUIPartsReponse extends NaMaDTO
{
	private Integer linesCountInGrids;
	private Boolean useKendoRichEditor;
	private Boolean showOldBarcodeMenu;
	private CustomGUIComponentsMetadata tooltipsAndReportsAndRevise;
	private List<TemplateMetadata> templates;
	private Boolean useRejectDecision;
	private Boolean useReturnDecision;
	private Boolean useEscalateToSupervisor;
	private Boolean useEscalateToSpecificEmployee;
	private Boolean useReturnToPreviousStep;
	private Boolean useSignatureInApprovalAttachment;
	private Boolean openPrintInBrowserWindow;
	private CmnHijrTable hijrTable;
	private List<String> hijriFields;
	private HijriFormatter hijriFormatter;
	private Integer rateFractionalDecimalPlaces;
	private Integer percentageFractionalDecimalPlaces;
	private Boolean useBackgroundImage;
	private Boolean doNotUseDescriptorsInFields;
	private Boolean searchWithConnectedNamesInRefs;
	private Boolean shouldRedirectEditView;
	private List<NaMaError> criticalSystemMessages;
	private Map<String, String> gridColoursMap;
	private List<DTOInvItemLevelLine> itemLevels;
	private BigDecimal itemButtonWidth;
	private BigDecimal itemButtonHeight;
	private BigDecimal maxItemButtonsToShowInSearch;
	private Boolean showItemsAsButtonsInLastSearchLevel;
	private Boolean showCompanyNameNextToLogo;
	private Boolean printUsingNamaServer;
	private Boolean doNotShowDocumentCodeInNamaServerPrintingLog;
	private List<String> modules = new ArrayList<>();
	private String audioSpeechContextLanguage;

	public CustomGUIPartsReponse()
	{
	}

	public List<NaMaError> getCriticalSystemMessages()
	{
		if (criticalSystemMessages == null)
			criticalSystemMessages = new ArrayList<>();
		return criticalSystemMessages;
	}

	public void setCriticalSystemMessages(List<NaMaError> criticalSystemMessages)
	{
		this.criticalSystemMessages = criticalSystemMessages;
	}

	public CustomGUIPartsReponse(CustomGUIComponentsMetadata tooltipsAndReports, List<TemplateMetadata> templates, Boolean useRejectDecision,
			Boolean openPrintInBrowserWindow, Boolean useReturnDecision, CmnHijrTable hijrTable, HijriFormatter hijriFormatter,
			List<String> hijriFields, Integer rateFractionalDecimalPlaces, Integer percentageFractionalDecimalPlaces, Boolean useBackgroundImage,
			Boolean doNotUseDescriptorsInFields, Boolean useEscalateToSupervisor, Boolean useEscalateToSpecificEmployee,
			Boolean useReturnToPreviousStep, Boolean useKendoRichEditor, Integer linesCountInGrids, Map<String, String> gridColoursMap,
			Boolean printUsingNamaServer, Boolean doNotShowDocumentCodeInNamaServerPrintingLog)
	{
		this();
		this.tooltipsAndReportsAndRevise = tooltipsAndReports;
		this.templates = templates;
		this.useRejectDecision = useRejectDecision;
		this.useReturnDecision = useReturnDecision;
		this.hijrTable = hijrTable;
		this.hijriFields = hijriFields;
		this.hijriFormatter = hijriFormatter;
		this.openPrintInBrowserWindow = openPrintInBrowserWindow;
		this.rateFractionalDecimalPlaces = rateFractionalDecimalPlaces;
		this.percentageFractionalDecimalPlaces = percentageFractionalDecimalPlaces;
		this.useBackgroundImage = useBackgroundImage;
		this.doNotUseDescriptorsInFields = doNotUseDescriptorsInFields;
		this.useEscalateToSupervisor = useEscalateToSupervisor;
		this.useEscalateToSpecificEmployee = useEscalateToSpecificEmployee;
		this.useReturnToPreviousStep = useReturnToPreviousStep;
		this.useKendoRichEditor = useKendoRichEditor;
		this.linesCountInGrids = linesCountInGrids;
		this.gridColoursMap = gridColoursMap;
		this.printUsingNamaServer = printUsingNamaServer;
		this.doNotShowDocumentCodeInNamaServerPrintingLog=doNotShowDocumentCodeInNamaServerPrintingLog;
	}

	public Boolean getUseEscalateToSpecificEmployee()
	{
		return useEscalateToSpecificEmployee;
	}

	public void setUseEscalateToSpecificEmployee(Boolean useEscalateToSpecificEmployee)
	{
		this.useEscalateToSpecificEmployee = useEscalateToSpecificEmployee;
	}

	public CustomGUIComponentsMetadata getTooltipsAndReportsAndRevise()
	{
		return tooltipsAndReportsAndRevise;
	}

	public void setTooltipsAndReportsAndRevise(CustomGUIComponentsMetadata tooltipsAndReports)
	{
		this.tooltipsAndReportsAndRevise = tooltipsAndReports;
	}

	public List<TemplateMetadata> getTemplates()
	{
		return templates;
	}

	public void setTemplates(List<TemplateMetadata> templates)
	{
		this.templates = templates;
	}

	public Boolean getUseRejectDecision()
	{
		return useRejectDecision;
	}

	public void setUseRejectDecision(Boolean useRejectDecision)
	{
		this.useRejectDecision = useRejectDecision;
	}

	public Boolean getUseReturnDecision()
	{
		return useReturnDecision;
	}

	public void setUseReturnDecision(Boolean useReturnDecision)
	{
		this.useReturnDecision = useReturnDecision;
	}

	public CmnHijrTable getHijrTable()
	{
		return hijrTable;
	}

	public void setHijrTable(CmnHijrTable hijrTable)
	{
		this.hijrTable = hijrTable;
	}

	public List<String> getHijriFields()
	{
		if (hijriFields == null)
			hijriFields = new ArrayList<String>();
		return hijriFields;
	}

	public void setHijriFields(List<String> hijriFields)
	{
		this.hijriFields = hijriFields;
	}

	public HijriFormatter getHijriFormatter()
	{
		return hijriFormatter;
	}

	public void setHijriFormatter(HijriFormatter hijriFormatter)
	{
		this.hijriFormatter = hijriFormatter;
	}

	public Boolean getOpenPrintInBrowserWindow()
	{
		return openPrintInBrowserWindow;
	}

	public void setOpenPrintInBrowserWindow(Boolean openPrintInBrowserWindow)
	{
		this.openPrintInBrowserWindow = openPrintInBrowserWindow;
	}

	public Integer getRateFractionalDecimalPlaces()
	{
		return rateFractionalDecimalPlaces;
	}

	public void setRateFractionalDecimalPlaces(Integer rateFractionalDecimalPlaces)
	{
		this.rateFractionalDecimalPlaces = rateFractionalDecimalPlaces;
	}

	public Integer getPercentageFractionalDecimalPlaces()
	{
		return percentageFractionalDecimalPlaces;
	}

	public void setPercentageFractionalDecimalPlaces(Integer percentageFractionalDecimalPlaces)
	{
		this.percentageFractionalDecimalPlaces = percentageFractionalDecimalPlaces;
	}

	public Boolean getUseBackgroundImage()
	{
		return useBackgroundImage;
	}

	public void setUseBackgroundImage(Boolean useBackgroundImage)
	{
		this.useBackgroundImage = useBackgroundImage;
	}

	public Boolean getDoNotUseDescriptorsInFields()
	{
		return doNotUseDescriptorsInFields;
	}

	public void setDoNotUseDescriptorsInFields(Boolean doNotUseDescriptorsInFields)
	{
		this.doNotUseDescriptorsInFields = doNotUseDescriptorsInFields;
	}

	public Boolean getUseEscalateToSupervisor()
	{
		return useEscalateToSupervisor;
	}

	public void setUseEscalateToSupervisor(Boolean useEscalateToSupervisor)
	{
		this.useEscalateToSupervisor = useEscalateToSupervisor;
	}

	public Boolean getUseReturnToPreviousStep()
	{
		return useReturnToPreviousStep;
	}

	public void setUseReturnToPreviousStep(Boolean useReturnToPreviousStep)
	{
		this.useReturnToPreviousStep = useReturnToPreviousStep;
	}

	public Boolean getUseSignatureInApprovalAttachment()
	{
		return useSignatureInApprovalAttachment;
	}

	public void setUseSignatureInApprovalAttachment(Boolean useSignatureInApprovalAttachment)
	{
		this.useSignatureInApprovalAttachment = useSignatureInApprovalAttachment;
	}

	public void setUseKendoRichEditor(Boolean useKendoRichEditor)
	{
		this.useKendoRichEditor = useKendoRichEditor;
	}

	public Boolean getUseKendoRichEditor()
	{
		return useKendoRichEditor;
	}

	public Boolean getPrintUsingNamaServer()
	{
		return printUsingNamaServer;
	}

	public void setPrintUsingNamaServer(Boolean printUsingNamaServer)
	{
		this.printUsingNamaServer = printUsingNamaServer;
	}

	public Boolean getDoNotShowDocumentCodeInNamaServerPrintingLog()
	{
		return doNotShowDocumentCodeInNamaServerPrintingLog;
	}

	public void setDoNotShowDocumentCodeInNamaServerPrintingLog(Boolean doNotShowDocumentCodeInNamaServerPrintingLog)
	{
		this.doNotShowDocumentCodeInNamaServerPrintingLog = doNotShowDocumentCodeInNamaServerPrintingLog;
	}

	public Integer getLinesCountInGrids()
	{
		return linesCountInGrids;
	}

	public void setLinesCountInGrids(Integer linesCountInGrids)
	{
		this.linesCountInGrids = linesCountInGrids;
	}

	public Boolean getShowOldBarcodeMenu()
	{
		return showOldBarcodeMenu;
	}

	public void setShowOldBarcodeMenu(Boolean showOldBarcodeMenu)
	{
		this.showOldBarcodeMenu = showOldBarcodeMenu;
	}

	public Boolean getSearchWithConnectedNamesInRefs()
	{
		return searchWithConnectedNamesInRefs;
	}

	public void setSearchWithConnectedNamesInRefs(Boolean searchWithConnectedNamesInRefs)
	{
		this.searchWithConnectedNamesInRefs = searchWithConnectedNamesInRefs;
	}

	public Boolean getShouldRedirectEditView()
	{
		return shouldRedirectEditView;
	}

	public void setShouldRedirectEditView(Boolean shouldRedirectEditView)
	{
		this.shouldRedirectEditView = shouldRedirectEditView;
	}

	public Map<String, String> getGridColoursMap()
	{
		if (gridColoursMap == null)
			gridColoursMap = new HashMap<>();
		return gridColoursMap;
	}

	public void setGridColoursMap(Map<String, String> gridColoursMap)
	{
		this.gridColoursMap = gridColoursMap;
	}

	public List<DTOInvItemLevelLine> getItemLevels()
	{
		if (ObjectChecker.isEmptyOrNull(itemLevels))
			itemLevels = new ArrayList<>();
		return itemLevels;
	}

	public void setItemLevels(List<DTOInvItemLevelLine> itemLevels)
	{
		this.itemLevels = itemLevels;
	}

	public BigDecimal getMaxItemButtonsToShowInSearch()
	{
		return maxItemButtonsToShowInSearch;
	}

	public void setMaxItemButtonsToShowInSearch(BigDecimal maxItemButtonsToShowInSearch)
	{
		this.maxItemButtonsToShowInSearch = maxItemButtonsToShowInSearch;
	}

	public Boolean getShowItemsAsButtonsInLastSearchLevel()
	{
		return showItemsAsButtonsInLastSearchLevel;
	}

	public void setShowItemsAsButtonsInLastSearchLevel(Boolean showItemsAsButtonsInLastSearchLevel)
	{
		this.showItemsAsButtonsInLastSearchLevel = showItemsAsButtonsInLastSearchLevel;
	}

	public BigDecimal getItemButtonWidth()
	{
		return itemButtonWidth;
	}

	public void setItemButtonWidth(BigDecimal itemButtonWidth)
	{
		this.itemButtonWidth = itemButtonWidth;
	}

	public BigDecimal getItemButtonHeight()
	{
		return itemButtonHeight;
	}

	public void setItemButtonHeight(BigDecimal itemButtonHeight)
	{
		this.itemButtonHeight = itemButtonHeight;
	}

	public Boolean getShowCompanyNameNextToLogo()
	{
		return showCompanyNameNextToLogo;
	}

	public void setShowCompanyNameNextToLogo(Boolean showCompanyNameNextToLogo)
	{
		this.showCompanyNameNextToLogo = showCompanyNameNextToLogo;
	}

	public List<String> getModules()
	{
		return modules;
	}

	public void setModules(List<String> modules)
	{
		this.modules = modules;
	}

	public String getAudioSpeechContextLanguage()
	{
		return audioSpeechContextLanguage;
	}

	public void setAudioSpeechContextLanguage(String audioSpeechContextLanguage)
	{
		this.audioSpeechContextLanguage = audioSpeechContextLanguage;
	}
}
