package com.namasoft.common.layout.metadata;

import com.namasoft.common.HasId;
import com.namasoft.common.utilities.*;

import java.util.*;

@SuppressWarnings({ "serial", "rawtypes" })
public class FieldMetaData extends BasicFieldMetaData
{
	private DTOFieldSpecs fieldSpecs;
	private String detailClassName;
	private boolean detail = false;
	private boolean required = false;
	private boolean isAdditional = false;
	private FieldInformation fieldInformation;
	private boolean singleColumn = false;
	private boolean guiField = false;
	private boolean calculated = false;
	private boolean enabled = true;
	private boolean systemField = false;
	private String relatedToFeature;
	private String decimalScaleStrategy;
	private String defaultValue;
	private transient boolean forCriteria;
	private Boolean onListOkRunAction;
	private Boolean onOkKeepSelectedItemsOnly;

	public FieldMetaData()
	{

	}

	public FieldMetaData(String id)
	{
		this();
		setFieldId(id);
	}

	public DTOFieldSpecs getFieldSpecs()
	{
		return fieldSpecs;
	}

	public void setFieldSpecs(DTOFieldSpecs fieldSpecs)
	{
		this.fieldSpecs = fieldSpecs;
	}

	public FieldMetaData allowedValues(String... values)
	{
		setAllowedValues(Arrays.asList(values));
		return this;
	}

	public FieldMetaData references(String referencedEntity)
	{
		setReferencedEntityType(referencedEntity);
		return this;
	}

	public FieldMetaData type(FieldType type)
	{
		setFieldType(type);
		return this;
	}

	public FieldMetaData id(String id)
	{
		setFieldId(id);
		return this;
	}

	public String getDetailClassName()
	{
		return detailClassName;
	}

	public void setDetailClassName(String detailClassName)
	{
		this.detailClassName = detailClassName;
	}

	public boolean isDetail()
	{
		return detail;
	}

	public void setDetail(boolean detail)
	{
		this.detail = detail;
	}

	public boolean isRequired()
	{
		return required;
	}

	public void setRequired(boolean required)
	{
		this.required = required;
	}

	public boolean isAdditional()
	{
		return isAdditional;
	}

	public void setAdditional(boolean isAdditional)
	{
		this.isAdditional = isAdditional;
	}

	public FieldInformation getFieldInformation()
	{
		return fieldInformation;
	}

	public void setFieldInformation(FieldInformation fieldInformation)
	{
		this.fieldInformation = fieldInformation;
	}

	@Override
	public void setFieldId(String fieldId)
	{
		super.setFieldId(fieldId);
		setFieldInformation(new FieldInformation(fieldId));
	}

	public void setSingleColumn(boolean singleColumn)
	{
		this.singleColumn = singleColumn;
	}

	public boolean getSingleColumn()
	{
		return singleColumn;
	}

	public static FieldMetaData text(String id)
	{
		FieldMetaData fieldMetaData = new FieldMetaData(id);
		fieldMetaData.setFieldType(FieldType.Text);
		return fieldMetaData;
	}

	public static FieldMetaData bigText(String id)
	{
		FieldMetaData fieldMetaData = new FieldMetaData(id);
		fieldMetaData.setFieldType(FieldType.BigText);
		return fieldMetaData;
	}

	public static FieldMetaData binary(String id)
	{
		FieldMetaData fieldMetaData = new FieldMetaData(id);
		fieldMetaData.setFieldType(FieldType.Binary);
		return fieldMetaData;
	}

	public static FieldMetaData booleanField(String id)
	{
		FieldMetaData fieldMetaData = new FieldMetaData(id);
		fieldMetaData.setFieldType(FieldType.Boolean);
		return fieldMetaData;
	}

	public static FieldMetaData enumFieldType(String id, String enumType)
	{
		FieldMetaData fieldMetaData = new FieldMetaData(id);
		fieldMetaData.setFieldType(FieldType.Enum);
		fieldMetaData.setEnumTypeName(enumType);
		return fieldMetaData;
	}

	public static FieldMetaData enumFieldFromList(String id, List<String> allowedValues)
	{
		FieldMetaData fieldMetaData = new FieldMetaData(id);
		fieldMetaData.setFieldType(FieldType.Enum);
		fieldMetaData.setAllowedValues(allowedValues);
		return fieldMetaData;
	}

	public static FieldMetaData enumField(String id, String... allowedValues)
	{
		return enumFieldFromList(id, Arrays.asList(allowedValues));
	}

	public static FieldMetaData enumFieldFormEnum(String id, Enum... allowedValues)
	{
		FieldMetaData fieldMetaData = new FieldMetaData(id);
		fieldMetaData.setFieldType(FieldType.Enum);
		fieldMetaData.setAllowedValues(CollectionsUtility.<Enum, String> convert(Arrays.asList(allowedValues), Converter.ENUM_NAME_CONVERTER));
		return fieldMetaData;
	}

	public static FieldMetaData enumField(String id, List<? extends HasId> allowedValues)
	{
		if (ObjectChecker.isEmptyOrNull(allowedValues))
			return enumField(id);
		String[] allowedValuesArr = new String[allowedValues.size()];
		for (int i = 0; i < allowedValuesArr.length; i++)
		{
			allowedValuesArr[i] = allowedValues.get(i).getId();
		}
		return enumField(id, allowedValuesArr);
	}

	public boolean isGuiField()
	{
		return guiField;
	}

	public void setGuiField(boolean guiField)
	{
		this.guiField = guiField;
	}

	public boolean isEnabled()
	{
		return enabled;
	}

	public void setEnabled(boolean enabled)
	{
		this.enabled = enabled;
	}

	public boolean isCalculated()
	{
		return calculated;
	}

	public void setCalculated(boolean calculated)
	{
		this.calculated = calculated;
	}

	public boolean isSystemField()
	{
		return systemField;
	}

	public String getRelatedToFeature()
	{
		return relatedToFeature;
	}

	public void setRelatedToFeature(String relatedToFeature)
	{
		this.relatedToFeature = relatedToFeature;
	}

	public String getDecimalScaleStrategy()
	{
		return decimalScaleStrategy;
	}

	public void setDecimalScaleStrategy(String decimalScaleStrategy)
	{
		this.decimalScaleStrategy = decimalScaleStrategy;
	}

	public void setSystemField(boolean systemField)
	{
		this.systemField = systemField;
	}

	public String getDefaultValue()
	{
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue)
	{
		this.defaultValue = defaultValue;
	}

	public static FieldMetaData guiField(String id, boolean enabled)
	{
		FieldMetaData fieldMetaData = new FieldMetaData(id);
		fieldMetaData.setGuiField(true);
		fieldMetaData.setFieldType(FieldType.Text);
		fieldMetaData.setEnabled(enabled);
		return fieldMetaData;
	}

	public static FieldMetaData guiColumn(String id, boolean enabled)
	{
		FieldMetaData fieldMetaData = guiField(id, enabled);
		fieldMetaData.setDetail(true);
		return fieldMetaData;
	}

	public static BasicFieldMetaData reference(String id, String referencedEntity)
	{
		BasicFieldMetaData metaData = new BasicFieldMetaData(id);
		metaData.setFieldType(FieldType.Reference);
		metaData.setReferencedEntityType(referencedEntity);
		return metaData;
	}

	public static BasicFieldMetaData date(String id)
	{
		BasicFieldMetaData metaData = new BasicFieldMetaData(id);
		metaData.setFieldType(FieldType.Date);
		return metaData;
	}

	public static BasicFieldMetaData decimal(String id)
	{
		BasicFieldMetaData metaData = new BasicFieldMetaData(id);
		metaData.setFieldType(FieldType.Decimal);
		return metaData;
	}

	public void cloneTo(FieldMetaData fieldMetaData)
	{
		super.cloneTo(fieldMetaData);
		fieldMetaData.fieldSpecs = this.fieldSpecs;
		fieldMetaData.detailClassName = this.detailClassName;
		fieldMetaData.detail = this.detail;
		fieldMetaData.required = this.required;
		fieldMetaData.isAdditional = this.isAdditional;
		fieldMetaData.singleColumn = this.singleColumn;
		fieldMetaData.guiField = this.guiField;
		fieldMetaData.calculated = this.calculated;
		fieldMetaData.enabled = this.enabled;
		fieldMetaData.systemField = this.systemField;
		fieldMetaData.relatedToFeature = this.relatedToFeature;
		fieldMetaData.decimalScaleStrategy = decimalScaleStrategy;
		fieldMetaData.fieldInformation = new FieldInformation();
		fieldMetaData.defaultValue = this.defaultValue;
		if (this.fieldInformation != null)
			this.fieldInformation.cloneTo(fieldMetaData.fieldInformation);
	}

	public static FieldMetaData from(BasicFieldMetaData metaData)
	{
		FieldMetaData fieldMetaData = new FieldMetaData();
		metaData.cloneTo(fieldMetaData);
		return fieldMetaData;
	}

	public static boolean isSystemField(BasicFieldMetaData fieldMetaData)
	{
		if (fieldMetaData != null && fieldMetaData instanceof FieldMetaData)
			return ((FieldMetaData) fieldMetaData).isSystemField();
		return false;
	}

	public static FieldMetaData genericReference(String id, String... allowedEntities)
	{
		FieldMetaData fieldMetaData = new FieldMetaData();
		fieldMetaData.setFieldId(id);
		fieldMetaData.setFieldType(FieldType.Genericreference);
		fieldMetaData.setAllowedValues(new ArrayList<String>(Arrays.asList(allowedEntities)));
		return fieldMetaData;
	}

	public void markForCriteria(boolean b)
	{
		this.forCriteria = b;
	}

	public boolean forCriteria()
	{
		return forCriteria;
	}

	public boolean notForCriteria()
	{
		return !forCriteria();
	}

	public FieldMetaData enumTypeName(String enumTypeName)
	{
		super.enumTypeName(enumTypeName);
		return this;
	}

	@Override
	public void cloneTo(BasicFieldMetaData md)
	{
		super.cloneTo(md);
		if (md instanceof FieldMetaData)
		{
			FieldMetaData fd = (FieldMetaData) md;
			fd.fieldSpecs = this.fieldSpecs;
			fd.detailClassName = this.detailClassName;
			fd.detail = this.detail;
			fd.required = this.required;
			fd.isAdditional = this.isAdditional;
			fd.fieldInformation = this.fieldInformation;
			fd.singleColumn = this.singleColumn;
			fd.guiField = this.guiField;
			fd.calculated = this.calculated;
			fd.enabled = this.enabled;
			fd.systemField = this.systemField;
			fd.relatedToFeature = this.relatedToFeature;
			fd.decimalScaleStrategy = this.decimalScaleStrategy;
			fd.defaultValue = this.defaultValue;
			fd.forCriteria = this.forCriteria;
			fd.onListOkRunAction = this.onListOkRunAction;
			fd.onOkKeepSelectedItemsOnly = this.onOkKeepSelectedItemsOnly;
		}
	}

	public void setOnListOkRunAction(Boolean onListOkRunAction)
	{
		this.onListOkRunAction = onListOkRunAction;
	}

	public Boolean getOnListOkRunAction()
	{
		return onListOkRunAction;
	}

	public Boolean getOnOkKeepSelectedItemsOnly()
	{
		return onOkKeepSelectedItemsOnly;
	}

	public void setOnOkKeepSelectedItemsOnly(Boolean onOkKeepSelectedItemsOnly)
	{
		this.onOkKeepSelectedItemsOnly = onOkKeepSelectedItemsOnly;
	}
}
