package com.namasoft.common.layout.metadata;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class ReportMetadataContainer extends NaMaDTO
{
	private ReportMetadata metadata;
	private EntityReferenceData report;
	private DTOHasOverrideDimensionOptions reportOverrideOptions;
	private DTOHasOverrideDimensionOptions globalOverrideOptions;


	public ReportMetadataContainer()
	{
	}

	public ReportMetadataContainer(EntityReferenceData report, ReportMetadata metadata, DTOHasOverrideDimensionOptions reportOverrideOptions,
			DTOHasOverrideDimensionOptions globalOverrideOptions)
	{
		this.report = report;
		this.metadata = metadata;
		this.reportOverrideOptions = reportOverrideOptions;
		this.globalOverrideOptions = globalOverrideOptions;
	}

	public ReportMetadata getMetadata()
	{
		return metadata;
	}

	public void setMetadata(ReportMetadata metadata)
	{
		this.metadata = metadata;
	}

	public EntityReferenceData getReport()
	{
		return report;
	}

	public void setReport(EntityReferenceData report)
	{
		this.report = report;
	}

	public DTOHasOverrideDimensionOptions getReportOverrideOptions()
	{
		return reportOverrideOptions;
	}

	public void setReportOverrideOptions(DTOHasOverrideDimensionOptions reportOverrideOptions)
	{
		this.reportOverrideOptions = reportOverrideOptions;
	}

	public DTOHasOverrideDimensionOptions getGlobalOverrideOptions()
	{
		return globalOverrideOptions;
	}

	public void setGlobalOverrideOptions(DTOHasOverrideDimensionOptions globalOverrideOptions)
	{
		this.globalOverrideOptions = globalOverrideOptions;
	}
}
