package com.namasoft.common.objects;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOCostRequestDataResp extends ServiceResponse
{
    protected List<DTOCostRequestData> list;
    private Integer totalRecords;
    private Integer awaitingLedgerGenerationCount;
    private Date trackProcessingCountsFrom;

    public DTOCostRequestDataResp(List<DTOCostRequestData> list, ResultDTO result)
    {
        setList(list);
        setResult(result);
    }

    public DTOCostRequestDataResp(List<DTOCostRequestData> list)
    {
        setList(list);
        setResult(ResultDTO.success());
    }

    public DTOCostRequestDataResp()
    {
    }

    public List<DTOCostRequestData> getList()
    {
        if (list == null)
            return list = new ArrayList<>();
        return list;
    }

    public void setList(List<DTOCostRequestData> list)
    {
        this.list = list;
    }

    public Integer getTotalRecords()
    {
        return totalRecords;
    }

    public void setTotalRecords(Integer totalRecords)
    {
        this.totalRecords = totalRecords;
    }

    public Date getTrackProcessingCountsFrom()
    {
        return trackProcessingCountsFrom;
    }

    public void setTrackProcessingCountsFrom(Date trackProcessingCountsFrom)
    {
        this.trackProcessingCountsFrom = trackProcessingCountsFrom;
    }

    public Integer getAwaitingLedgerGenerationCount()
    {
        return awaitingLedgerGenerationCount;
    }

    public void setAwaitingLedgerGenerationCount(Integer awaitingLedgerGenerationCount)
    {
        this.awaitingLedgerGenerationCount = awaitingLedgerGenerationCount;
    }
}
