package com.namasoft.common.preferences;

import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.criteria.DTOFilledQuestionField;
import com.namasoft.common.layout.LayoutType;
import com.namasoft.common.layout.Owner;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ListLayoutPreferences extends LayoutPreferences
{
	private List<DTOFilledQuestionField> questionFields;
	private DTOCriteria criteria;
	private String sortBy;
	private Integer pageSize;
	private List<String> displayedColumns;

	public ListLayoutPreferences()
	{
	}

	public ListLayoutPreferences(Owner owner, String id, List<DTOFilledQuestionField> questionFields, DTOCriteria criteria, String sortBy,
			Integer pageSize, List<String> displayedColumns, String preferencesId)
	{
		super(owner, id, preferencesId);
		this.questionFields = questionFields;
		this.criteria = criteria;
		this.sortBy = sortBy;
		this.pageSize = pageSize;
		this.displayedColumns = displayedColumns;
	}

	public List<DTOFilledQuestionField> getQuestionFields()
	{
		return questionFields;
	}

	public void setQuestionFields(List<DTOFilledQuestionField> questionFields)
	{
		this.questionFields = questionFields;
	}

	public DTOCriteria getCriteria()
	{
		return criteria;
	}

	public void setCriteria(DTOCriteria criteria)
	{
		this.criteria = criteria;
	}

	public String getSortBy()
	{
		return sortBy;
	}

	public void setSortBy(String sortBy)
	{
		this.sortBy = sortBy;
	}

	public Integer getPageSize()
	{
		return pageSize;
	}

	public void setPageSize(Integer pageSize)
	{
		this.pageSize = pageSize;
	}

	public List<String> getDisplayedColumns()
	{
		return displayedColumns;
	}

	public void setDisplayedColumns(List<String> displayedColumns)
	{
		this.displayedColumns = displayedColumns;
	}

	@Override
	public LayoutType type()
	{
		return LayoutType.LIST;
	}

}
