package com.namasoft.common.urlutils;

import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.constants.PlaceTokens;
import com.namasoft.common.constants.ViewMode;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.NaMaLayersConnector;
import com.namasoft.common.utils.ServerCommonUtils;

import java.util.ArrayList;
import java.util.List;

import static com.namasoft.common.constants.PlaceTokens.*;
import static com.namasoft.common.utilities.NaMaKeyValuePairsTokenizer.pair;

public class ReportNewCreator
{
	private List<FieldValue> values;
	private FieldValue current;
	private String entity;
	private String menuCode;
	private String viewName;

	public class FieldValue
	{
		private String id;
		private String value;
		private String row;

		@Override
		public String toString()
		{
			return ReportNewCreator.this.toString();
		}

		public String asStr()
		{
			if (ObjectChecker.isEmptyOrNull(id))
				return "";
			return id + ":=" + ObjectChecker.toStringOrEmpty(value) + (ObjectChecker.isEmptyOrNull(row) ? "" : ":@" + row);
		}

		public FieldValue field(Object f)
		{
			return f(f);
		}

		public FieldValue f(Object field)
		{
			if (ObjectChecker.isNotEmptyOrNull(current.id))
			{
				current = new FieldValue();
				values.add(current);
			}
			current.id = ObjectChecker.toStringOrEmpty(field);
			return current;
		}

		public FieldValue value(Object v)
		{
			return v(v);
		}

		public FieldValue v(Object v)
		{
			if (v != null && v.getClass().isArray())
				v = ServerCommonUtils.byteArrayToUUID((byte[]) v);
			current.value = ObjectChecker.toStringOrEmpty(v);
			return current;
		}

		public FieldValue row(Object v)
		{
			return r(v);
		}

		public FieldValue r(Object v)
		{
			current.row = ObjectChecker.toStringOrEmpty(v);
			return current;
		}

		public ReportNewCreator root()
		{
			return ReportNewCreator.this;
		}
	}

	public FieldValue field(Object f)
	{
		return current.f(f);
	}

	public FieldValue f(Object field)
	{
		return current.f(field);
	}

	public FieldValue value(Object v)
	{
		return current.v(v);
	}

	public FieldValue v(Object v)
	{
		return current.v(v);
	}

	public FieldValue row(Object v)
	{
		return current.r(v);
	}

	public FieldValue r(Object v)
	{
		return current.r(v);
	}

	public ReportNewCreator entity(Object entity)
	{
		this.entity = ObjectChecker.toStringOrEmpty(entity);
		return this;
	}

	@Override
	public String toString()
	{
		StringBuilder fields = new StringBuilder();
		for (int i = 0; i < values.size(); i++)
		{
			FieldValue v = values.get(i);
			if (i > 0)
				fields.append("--");
			if (ObjectChecker.isNotEmptyOrNull(v.id))
				fields.append(v.asStr());
		}

		String compressedFields = fields.toString();
		compressedFields = CommonConstants.BASE64_PREFIX + ObjectToURLUtil.encode(compressedFields);
		return NaMaLayersConnector.getInstance().getGuiServerURL() + PlaceTokens.tokenize(PlaceTokens.PREFIX_EDIT, pair(PRM_ENTITY_TYPE, entity),
				pair(PRM_FIELDS, compressedFields), pair(PRM_VIEW, ViewMode.NEW), pair(PRM_MENU_HASH, menuCode), pair(PRM_LIST_VIEW_NAME, viewName));
	}

	public ReportNewCreator()
	{
		values = new ArrayList<>();
		current = new FieldValue();
		values.add(current);
	}

	public ReportNewCreator menuCode(Object menuCode)
	{
		this.menuCode = ObjectChecker.toStringOrEmpty(menuCode);
		return this;
	}

	public ReportNewCreator viewName(Object viewName)
	{
		this.viewName = ObjectChecker.toStringOrEmpty(viewName);
		return this;
	}

	public ReportNewCreator root()
	{
		return this;
	}
}
