package com.namasoft.common.utilities;

import com.namasoft.common.utils.ServerStringUtils;

import java.security.SecureRandom;

public class DiscountCouponUtil
{
	private static SecureRandom secureRandom = new SecureRandom();

	public static String generateCouponCode(String prefix, int suffixLength, Long suffixFirstNumber, String codingMethod, int tryCount)
	{
		switch (codingMethod)
		{
		case "Automatic":
			long sequence = suffixFirstNumber + tryCount;
			return prefix + ServerStringUtils.leftPad(sequence, suffixLength);
		case "Random":
			return generateRandomCouponCode(suffixLength);
		case "Manual":
			return "";
		}
		throw new RuntimeException("Unhandled coding method: " + codingMethod);
	}

	public static String generateRandomCouponCode(int suffixLength)
	{
		return ServerStringUtils.leftPad(Math.abs(secureRandom.nextLong()), suffixLength).substring(0, suffixLength);
	}
}
