package com.namasoft.common.utilities;
import com.namasoft.common.fieldids.newids.supplychain.IdsOfInvItem;


import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.namasoft.common.Pair;
import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.flatobjects.EntityReferenceData;

public class InvItemRefEncoder
{
	public static final String SECOND_SERIAL = "secondSerial";
	public static final String MIN_SALES_QTY_IS_PER_COUNT = "minSalesQtyIsPerCount";
	public static String allPropsFieldId = "allPropsFieldId";
	private static final ArrayList<String> propertiesOrder = new ArrayList<String>();
	static
	{
		propertiesOrder.add(IdsOfInvItem.hasCalcFormula.replace("has", "").toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasColor.replace("has", "").toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasExpiry.replace("has", "").toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasLot.replace("has", "").toLowerCase());
		propertiesOrder.add(IdsOfInvItem.measuresType.toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasMeasures.toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasPackages.replace("has", "").toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasRevisions.replace("hasRevisions", "revision").toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasSecondUnit.replace("has", "").toLowerCase());
		propertiesOrder.add(SECOND_SERIAL.toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasSerial.replace("has", "").toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasSize.replace("has", "").toLowerCase());
		propertiesOrder.add(IdsOfInvItem.hasWarrantyCode.replace("has", "").toLowerCase());
		propertiesOrder.add(MIN_SALES_QTY_IS_PER_COUNT.toLowerCase());
	}

	private static boolean booleanProperty(EntityReferenceData itemRef, String propertyFieldId, int bits)
	{
		if (ObjectChecker.isEmptyOrNull(itemRef) || ObjectChecker.isEmptyOrNull(itemRef.getExtraData()))
			return false;
		String allPropsValue = (String) itemRef.getExtraData().get(allPropsFieldId);
		if (ObjectChecker.isEmptyOrNull(allPropsValue))
			return false;
		int findPropertyMapOrder = findPropertyMapOrder(propertyFieldId);
		if (findPropertyMapOrder < 0)
			return false;
		int charAt = toInt(allPropsValue.charAt(findPropertyMapOrder));
		if (charAt < 0)
			return false;
		return hasPropertyOf(charAt, bits);
	}

	public static Pair<BigDecimal, Boolean> minItemSalesQty(EntityReferenceData itemRef, String uomID)
	{
		String minQtyMap = itemRef.get(IdsOfInvItem.minQtiesMap);
		if (ObjectChecker.isEmptyOrNull(minQtyMap))
			return new Pair<>(BigDecimal.ZERO, false);
		String[] qtyUOMPairs = minQtyMap.split(CommonConstants.SEPARATOR);
		for (String qtyUOMPair : qtyUOMPairs)
		{
			String[] qtyAndUOM = qtyUOMPair.split(CommonConstants.FIELD_PARTS_SEP);
			if (ObjectChecker.areEqual(qtyAndUOM[0], uomID.replaceAll("-", "")))
			{
				String val = qtyAndUOM[1];
				List<String> values = StringUtils.csvLineToList(val);
				BigDecimal value = new BigDecimal(values.get(0));
				boolean multiples = false;
				if (values.size() > 1)
					multiples = ObjectChecker.isTrue(CollectionsUtility.getLast(values));
				return new Pair<>(value, multiples);
			}
		}
		return new Pair<>(BigDecimal.ZERO, false);
	}

	public static boolean minSalesQtyIsPerCount(EntityReferenceData itemRef)
	{
		return hasTheProperty(itemRef, MIN_SALES_QTY_IS_PER_COUNT);
	}

	public static boolean hasTheProperty(EntityReferenceData itemRef, String propertyFieldId)
	{
		return booleanProperty(itemRef, propertyFieldId, 0);
	}

	public static boolean canIssueProperty(EntityReferenceData itemRef, String propertyFieldId)
	{
		return booleanProperty(itemRef, propertyFieldId, 1);
	}

	public static boolean canReceiptProperty(EntityReferenceData itemRef, String propertyFieldId)
	{
		return booleanProperty(itemRef, propertyFieldId, 1);
	}

	public static StringBuilder addProperty(String propertyFieldId, StringBuilder encodedValue, boolean hasProperty)
	{
		return addProperty(propertyFieldId, encodedValue, hasProperty, true, true);
	}

	public static StringBuilder addProperty(String propertyFieldId, StringBuilder encodedValue, boolean hasProperty, boolean canEditInIssue,
			boolean canEditInReceipt)
	{
		int index = findPropertyMapOrder(propertyFieldId);
		if (index >= 0)
			encodedValue.setCharAt(index, toChar(intOfProps(hasProperty, canEditInIssue, canEditInReceipt)));
		return encodedValue;
	}

	private static char toChar(int intOfProps)
	{
		return (char) (((int) '0') + intOfProps);
	}

	private static int intOfProps(boolean prop1, boolean prop2, boolean prop3)
	{
		int ret = 0;
		if (prop1)
			ret += 1;
		if (prop2)
			ret += 2;
		if (prop3)
			ret += 4;
		return ret;
	}

	private static int findPropertyMapOrder(String propertyFieldId)
	{
		String lowerCase = propertyFieldId.toLowerCase();
		if(lowerCase.endsWith(".box"))
			lowerCase = "packages";
		for (int i = 0; i < propertiesOrder.size(); i++)
		{
			if (lowerCase.contains(propertiesOrder.get(i)))
			{
				return i;
			}
		}
		return -1;
	}

	private static int toInt(Character value)
	{
		if (value >= '0' && value <= '9')
			return (int) value - (int) '0';
		return ((int) value - (int) 'a') + 10;
	}

	private static boolean hasPropertyOf(int charValue, int bits)
	{
		return (charValue >> bits) % 2 == 1;
	}
}
