package com.namasoft.common.utilities;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;

public class SafeBigDecimal
{
	private BigDecimal value;

	public SafeBigDecimal(BigDecimal n)
	{
		this.value = n;
	}

	public BigDecimal getValue()
	{
		return ObjectChecker.toZeroIfNull(value);
	}

	public SafeBigDecimal add(SafeBigDecimal n)
	{
		return add(n.getValue());
	}

	public SafeBigDecimal add(BigDecimal n)
	{
		return n(getValue().add(ObjectChecker.toZeroIfNull(n)));
	}

	public static SafeBigDecimal n(BigDecimal n)
	{
		return new SafeBigDecimal(n);
	}

	public SafeBigDecimal subtract(BigDecimal n)
	{
		return n(getValue().subtract(ObjectChecker.toZeroIfNull(n)));
	}

	public BigDecimal v()
	{
		return getValue();
	}

	public BigDecimal toBigDecimal()
	{
		return getValue();
	}

	public static SafeBigDecimal zero()
	{
		return new SafeBigDecimal(BigDecimal.ZERO);
	}

	public SafeBigDecimal multiply(BigDecimal n)
	{
		return n(getValue().multiply(ObjectChecker.toZeroIfNull(n)));
	}

	public SafeBigDecimal divide(SafeBigDecimal maqam, Integer scale)
	{
		return divide(maqam.v(), scale);
	}

	public SafeBigDecimal divide(SafeBigDecimal maqam)
	{
		return divide(maqam.v(), 20);
	}
	public SafeBigDecimal divide(Integer maqam, Integer scale)
	{
		return n(NaMaMath.divide(getValue(), BigDecimal.valueOf(maqam), scale));
	}

	public SafeBigDecimal divide(BigDecimal maqam, Integer scale)
	{
		return n(NaMaMath.divide(getValue(), maqam, scale));
	}

	private static BigDecimal toZeroIFNull(BigDecimal arg)
	{
		return ObjectChecker.isEmptyOrZero(arg) ? BigDecimal.ZERO : arg;
	}

	public static <T> BigDecimal totalize(List<T> list, Function<T, BigDecimal> fetcher)
	{
		if (ObjectChecker.isEmptyOrNull(list))
			return zero().getValue();
		SafeBigDecimal total = zero();
		for (T l : list)
			total = total.add(fetcher.apply(l));
		return total.getValue();
	}

	public static BigDecimal totalize(BigDecimal... args)
	{
		if (args == null)
			return BigDecimal.ZERO;

		BigDecimal sum = BigDecimal.ZERO;

		for (BigDecimal arg : args)
		{
			sum = sum.add(toZeroIFNull(arg));
		}
		return sum;
	}

	public SafeBigDecimal multiply(Integer i)
	{
		if (i == null)
			i = 0;
		return multiply(BigDecimal.valueOf(i));
	}

	public static SafeBigDecimal n(Integer i)
	{
		if (i == null)
			i = 0;
		return n(BigDecimal.valueOf(i));
	}


}
