package com.namasoft.common.utilities;

import java.util.Arrays;
import java.util.List;

public class SalaryFormulaUtil
{
	public static boolean validateCalcFormula(String[] formulaExpression)
	{
		boolean isPreviousOperator = false;
		List<String> parameters = Arrays.asList("B.S", "RES", "Trans", "W.N", "SOC", "A.D1", "A.D2", "A.D3", "A.D4", "A.D5", ")", "(");
		List<String> operators = Arrays.asList("*", "+", "-", ")", "(", "/");
		String numericMatchingRegix = "((-|\\+)?[0-9]+(\\.[0-9]+)?)+";
		for (String str : formulaExpression)
		{
			if (parameters.contains(str) || str.matches(numericMatchingRegix) || operators.contains(str))
			{
				if (operators.contains(str))
				{
					if (isPreviousOperator)
						return false;
					isPreviousOperator = true;
				}
				else
				{
					isPreviousOperator = false;
				}
			}
			else
				return false;
		}

		return true;
	}

	public static String[] splitFormulaString(String input)
	{
		List<Character> operators = Arrays.asList('*', '+', '-', '/', ')', '(');
		int length = input.length();
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < length; i++)
		{
			char charAt = input.charAt(i);
			if (charAt != ' ')
			{
				if (operators.contains(charAt))
				{
					sb.append(" ").append(charAt).append(" ");
				}
				else
				{
					sb.append(charAt);
				}
			}
		}
		String formula = sb.toString();
		String exp[] = formula.split(" ");
		return exp;
	}

}
