package com.namasoft.common.utilities;

import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.flatobjects.tempo.ComplexRenderer;

import java.util.*;
import java.util.stream.Collectors;

public class StringUtils
{

	public static String removeOccurance(String source, String start, String end)
	{
		int startIndex = source.indexOf(start);
		int lastIndex = source.indexOf(end, startIndex + start.length());
		while (startIndex > -1 && lastIndex > -1)
		{
			String prefix = "";
			if (startIndex > 0)
				prefix = source.substring(0, startIndex);
			String suffix = "";
			if (lastIndex + end.length() < source.length())
				suffix = source.substring(lastIndex + end.length());
			source = prefix + suffix;
			startIndex = source.indexOf(start);
			lastIndex = source.indexOf(end, startIndex + start.length());
		}
		return source;
	}

	public static String getInnerStringAfter(String source, String operBraket, String closedBracket, String afterOccurance)
	{
		int index = source.indexOf(afterOccurance);
		if (index < 0)
			return "";
		return getInnerString(source.substring(index + afterOccurance.length()), operBraket, closedBracket);
	}

	public static String getInnerStringBefore(String source, String operBraket, String closedBracket, String beforeOccurence)
	{
		int index = source.indexOf(beforeOccurence);
		if (index < 0)
			return "";
		source = source.substring(0, index);
		int startIndex = source.lastIndexOf(operBraket);
		return getInnerString(source.substring(startIndex, index), operBraket, closedBracket);
	}

	public static int getIndexBefore(String source, String toSearchFor, String beforeOccurence)
	{
		int index = source.indexOf(beforeOccurence);
		if (index < 0)
			return -1;
		source = source.substring(0, index);
		return source.lastIndexOf(toSearchFor);
	}

	public static String getInnerString(String source, String openBraket, String closedBracket)
	{
		return getInnerString(source, openBraket, closedBracket, "####null#####");
	}

	public static List<String> getAllInnerStringsWithDuplicates(String source, String operBraket, String closedBracket)
	{
		ArrayList<String> innerStrings = new ArrayList<>();
		String current;
		while ((current = getInnerString(source, operBraket, closedBracket)) != null)
		{
			innerStrings.add(current);
			String str = operBraket + current + closedBracket;
			int index = source.indexOf(str);
			source = source.substring(index + str.length());
		}
		return innerStrings;
	}

	public static List<String> getAllInnerStrings(String source, String operBraket, String closedBracket)
	{
		ArrayList<String> innerStrings = new ArrayList<>();
		String current;
		while ((current = getInnerString(source, operBraket, closedBracket)) != null)
		{
			innerStrings.add(current);
			source = source.replace(operBraket + current + closedBracket, "&_$rp(^_^)cd$_&");
		}
		return innerStrings;
	}

	private static String getInnerString(String source, String openBracket, String closedBracket, String innerValue)
	{
		if (ObjectChecker.isEmptyOrNull(source))
			return null;
		int startIndex = source.indexOf(openBracket);
		if (startIndex < 0)
			return null;
		int inners = 0;
		int endIndex = -1;
		for (int i = startIndex + openBracket.length(); i < source.length(); i++)
		{
			if (source.substring(i).startsWith(innerValue))
			{
				inners++;
			}
			else if (source.substring(i).startsWith(closedBracket))
			{
				if (inners == 0)
				{
					endIndex = i;
					break;
				}
				else
				{
					inners--;
				}
			}
		}
		if (endIndex < 0)
			return null;
		return source.substring(startIndex + openBracket.length(), endIndex);
	}

	public static String firstLetterLower(String propertyName)
	{
		String value = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
		return value;
	}

	public static String firstLetterUpper(String propertyName)
	{
		String value = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
		return value;
	}

	public static boolean isAnyEqualIgnoreCaseToFirst(String first, String... others)
	{
		for (String other : others)
		{
			if (first != null && first.equalsIgnoreCase(other))
				return true;
		}
		return false;
	}

	public static boolean anyContainsIgnoreCase(String str, String... others)
	{
		str = str.toLowerCase();
		for (String other : others)
		{
			if (ObjectChecker.isNotEmptyOrNull(other))
			{
				other = other.toLowerCase();
				if (other.contains(str))
					return true;
			}
		}
		return false;
	}

	public static int getNIndexOf(String target, String toSearch, int n)
	{
		int lastIndex = 0;
		for (int i = 0; i < n; i++)
		{
			lastIndex = target.indexOf(toSearch, lastIndex + 1);
			if (lastIndex < 0)
				return lastIndex;
		}
		return lastIndex;
	}

	public static String replaceDotWith_(String id)
	{
		return id.replaceAll("\\.", "_");
	}

	public static String firstWord(String str)
	{
		return substringBefore(str, " ");
	}

	public static String substringBefore(String str, String separator)
	{
		if (ObjectChecker.isEmptyOrNull(str) || separator == null)
		{
			return str;
		}
		if (separator.length() == 0)
		{
			return "";
		}
		int pos = str.indexOf(separator);
		if (pos == -1)
		{
			return str;
		}
		return str.substring(0, pos);
	}

	public static String substringAfter(String str, String separator)
	{
		if (ObjectChecker.isEmptyOrNull(str) || separator == null)
		{
			return str;
		}
		if (separator.isEmpty())
		{
			return "";
		}
		int pos = str.indexOf(separator);
		if (pos == -1)
		{
			return "";
		}
		return str.substring(pos + separator.length());
	}

	/**
	 * <p>Gets the String that is nested in between two Strings.
	 * Only the first match is returned.</p>
	 *
	 * <p>A <code>null</code> input String returns <code>null</code>.
	 * A <code>null</code> open/close returns <code>null</code> (no match).
	 * An empty ("") open and close returns an empty string.</p>
	 *
	 * <pre>
	 * StringUtils.substringBetween("wx[b]yz", "[", "]") = "b"
	 * StringUtils.substringBetween(null, *, *)          = null
	 * StringUtils.substringBetween(*, null, *)          = null
	 * StringUtils.substringBetween(*, *, null)          = null
	 * StringUtils.substringBetween("", "", "")          = ""
	 * StringUtils.substringBetween("", "", "]")         = null
	 * StringUtils.substringBetween("", "[", "]")        = null
	 * StringUtils.substringBetween("yabcz", "", "")     = ""
	 * StringUtils.substringBetween("yabcz", "y", "z")   = "abc"
	 * StringUtils.substringBetween("yabczyabcz", "y", "z")   = "abc"
	 * </pre>
	 *
	 * @param str   the String containing the substring, may be null
	 * @param open  the String before the substring, may be null
	 * @param close the String after the substring, may be null
	 * @return the substring, <code>null</code> if no match
	 * @since 2.0
	 */
	public static String substringBetween(String str, String open, String close)
	{
		if (str == null || open == null || close == null)
		{
			return null;
		}
		int start = str.indexOf(open);
		if (start != -1)
		{
			int end = str.indexOf(close, start + open.length());
			if (end != -1)
			{
				return str.substring(start + open.length(), end);
			}
		}
		return null;
	}

	public static String substringBetweenIncludingOpenAndClose(String str, String open, String close)
	{
		String s = substringBetween(str, open, close);
		if (ObjectChecker.isEmptyOrNull(s))
			return s;
		return open + s + close;
	}

	/**
	 * <p>Checks if a String is whitespace, empty ("") or null.</p>
	 *
	 * <pre>
	 * StringUtils.isBlank(null)      = true
	 * StringUtils.isBlank("")        = true
	 * StringUtils.isBlank(" ")       = true
	 * StringUtils.isBlank("bob")     = false
	 * StringUtils.isBlank("  bob  ") = false
	 * </pre>
	 *
	 * @param str the String to check, may be null
	 * @return <code>true</code> if the String is null, empty or whitespace
	 * @since 2.0
	 */
	public static boolean isBlank(String str)
	{
		int strLen;
		if (str == null || (strLen = str.length()) == 0)
		{
			return true;
		}
		for (int i = 0; i < strLen; i++)
		{
			if ((Character.isWhitespace(str.charAt(i)) == false))
			{
				return false;
			}
		}
		return true;
	}

	public static String substringAfterLast(String str, String separator)
	{
		if (ObjectChecker.isEmptyOrNull(str) || separator == null)
		{
			return str;
		}
		if (separator.length() == 0)
		{
			return "";
		}
		int pos = str.lastIndexOf(separator);
		if (pos == -1)
		{
			return "";
		}
		return str.substring(pos + separator.length());
	}

	public static String substringAfterLastOrStrIfSeparatorNotFound(String str, String separator)
	{
		if (ObjectChecker.isEmptyOrNull(str) || separator == null)
		{
			return str;
		}
		if (separator.length() == 0)
		{
			return "";
		}
		int pos = str.lastIndexOf(separator);
		if (pos == -1)
		{
			return str;
		}
		return str.substring(pos + separator.length());
	}

	public static String substringBeforeLast(String str, String separator)
	{
		if (ObjectChecker.isEmptyOrNull(str) || separator == null)
		{
			return str;
		}
		if (separator.length() == 0)
		{
			return "";
		}
		int pos = str.lastIndexOf(separator);
		if (pos == -1)
		{
			return str;
		}
		return str.substring(0, pos);
	}

	public static List<String> csvLineToList(String csv)
	{
		return csvLineToList(",", csv);
	}

	public static List<String> csvLineToListWithEmpty(String csv)
	{
		return csvLineToList(",", csv, false, true);
	}

	public static List<String> csvLineToList(String seperator, String csv)
	{
		return csvLineToList(seperator, csv, false);
	}

	public static List<String> csvLineToList(String seperator, String csv, boolean trim)
	{
		return csvLineToList(seperator, csv, trim, false);
	}

	public static List<String> csvLineToList(String seperator, String csv, boolean trim, boolean addEmpty)
	{
		if (ObjectChecker.isEmptyOrNull(csv))
			csv = "";
		String[] parts = csv.split(seperator);
		List<String> list = new ArrayList<String>(parts.length);
		for (String part : parts)
		{
			if (trim)
				part = part.trim();
			if (addEmpty || ObjectChecker.isNotEmptyOrNull(part))
				list.add(part);
		}
		return list;
	}

	public static StringBuilder appendWithSeperator(StringBuilder builder, String seperator, Object... what)
	{
		for (Object object : what)
		{
			if (builder.length() > 0)
				builder.append(seperator);
			builder.append(object);
		}
		return builder;
	}

	public static String toCSVLine(List<?> objects)
	{
		if (objects == null)
			return "";
		return toCSVLine(objects.toArray());
	}

	public static String toCSVLine(Object... objects)
	{
		return toCSVLineWithSep(",", objects);
	}

	public static String toCSVLineWithSep(String separator, List<?> objects)
	{
		if (objects == null)
			return "";
		return toCSVLineWithSep(separator, objects.toArray());
	}

	public static String toCSVLineWithSep(String separator, Object... objects)
	{
		if (objects == null)
			return "";
		StringBuilder line = new StringBuilder();
		for (int i = 0; i < objects.length; i++)
		{
			line.append(ObjectChecker.toStringOrEmpty(objects[i]));
			if (i < objects.length - 1)
			{
				line.append(separator);
			}
		}
		return line.toString();
	}

	public static String toCSVLineWithSepWithoutEmptyObjects(String separator, Object... objects)
	{
		if (objects == null)
			return "";
		return Arrays.stream(objects).filter(ObjectChecker::isNotEmptyOrNull).map(Object::toString).filter(ObjectChecker::isNotEmptyOrNull)
				.collect(Collectors.joining(separator));
	}

	public static <T> String concatNonEmptyObjectsAsCSV(List<T> objects)
	{
		return concatNonEmptyObjectsAsCSV(objects.toArray());
	}

	public static String concatNonEmptyObjectsAsCSV(Object... objects)
	{
		if (objects == null)
			return "";
		StringBuilder line = new StringBuilder();
		int added = 0;
		for (int i = 0; i < objects.length; i++)
		{
			if (ObjectChecker.isNotEmptyOrNull(ObjectChecker.toStringOrEmpty(objects[i])))
			{
				if (added > 0)
				{
					line.append(",");
				}
				line.append(ObjectChecker.toStringOrEmpty(objects[i]));
				added++;
			}
		}
		return line.toString();
	}

	public static String requestParam(String name, Object value)
	{
		if (ObjectChecker.isNotEmptyOrNull(value) && ObjectChecker.isNotEmptyOrNull(value.toString()))
			return name + "=" + value + "&";
		return "";
	}

	public static String PadLeft(String text, String addChar, int length)
	{
		int currentLength = 0;
		if (text == null)
			text = "";
		currentLength = text.length();
		String prefix = "";
		for (int i = currentLength; i < length; i++)
			prefix += addChar;
		return prefix + text;
	}

	public static String PadLeft(String text, int length)
	{
		return PadLeft(text, "0", length);
	}
	public static Object mask(Object value, String mask)
	{
		String str = value.toString();
		int currentSourceIndex = 0;
		String result = "";
		for (int i = 0; i < mask.length(); i++)
		{
			if (ObjectChecker.areEqual(mask.charAt(i), 'X'))
			{
				if (currentSourceIndex < str.length())
				{
					result += str.charAt(currentSourceIndex);
					currentSourceIndex++;
				}
			}
			else
			{
				result += mask.charAt(i);
			}
		}
		if (currentSourceIndex + 1 < str.length())
			result += str.substring(currentSourceIndex + 1, str.length());
		return result;
	}

	public static void main(String[] args)
	{
		StringUtils.getAllInnerStrings(ComplexRenderer.START_NEW_MSG, ComplexRenderer.START_NEW_MSG, ComplexRenderer.END_MSG);
		System.err.println(mask("111222333", "XXX.xXXX.YXXXXXAA"));
		System.err.println(mask("11122233344444455556666", "XXX.xXXX.YXXXXX"));
	}

	private static List<Character> VOWELS = Arrays.asList('a', 'e', 'i', 'o', 'u', 'y');

	public static String removeVowels(String path, int requiredLength)
	{
		int toRemove = path.length() - requiredLength;
		if (toRemove <= 0)
			return path;
		StringBuilder ret = new StringBuilder();
		int removed = 0;
		for (int i = 0; i < path.length(); i++)
		{
			Character charAt = path.charAt(i);
			if (removed <= toRemove && VOWELS.contains(charAt))
			{
				removed++;
				continue;
			}
			ret.append(charAt);
		}
		return ret.toString();
	}

	private static final char[] arNumbersArray = { '٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩' };
	private static final char[] enNumbersArray = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };

	public static String replaceArNumerals(String text)
	{
		if (ObjectChecker.isEmptyOrNull(text))
			return text;
		for (int i = 0; i < arNumbersArray.length; i++)
			text = text.replace(arNumbersArray[i], enNumbersArray[i]);
		return text;
	}

	public static String normalizeArabic(String arabic)
	{
		return replaceChars(arabic, CommonConstants.ARABIC_REPLACE___, CommonConstants.ARABIC_REPLACE_BY);
	}

	public static String enToAr(String str)
	{
		return replaceChars(str, CommonConstants.ENGLISH_KEYBOARD, CommonConstants.ARABIC_KEYBOARD_);
	}

	public static String arToEn(String str)
	{
		return replaceChars(str, CommonConstants.ARABIC_KEYBOARD_, CommonConstants.ENGLISH_KEYBOARD);
	}

	private static String replaceChars(String str, String[] replace, String[] replaceBy)
	{
		if (ObjectChecker.isEmptyOrNull(str))
			return str;
		for (int i = 0; i < replace.length; i++)
			str = str.replace(replace[i], replaceBy[i]);
		return str;
	}

	public static String toCamelCaseAndReplaceDotsWith_(String fullName)
	{
		if (ObjectChecker.isEmptyOrNull(fullName))
			return "";
		return Arrays.stream(fullName.split("\\.")).map(StringUtils::firstLetterUpper)
				.map(s -> s.replace('$', '_').replace('#', '_').replace("\"", "").replace('{', '_').replace("}", "").replace(':', '_'))
				.collect(Collectors.joining("_"));
	}

	public static String[] massReplace(String toReplace, String replacement, String... strings)
	{
		for (int i = 0; i < strings.length; i++)
		{
			strings[i] = strings[i].replace(toReplace, replacement);
		}
		return strings;
	}
}
