package com.namasoft.common.utils;

import com.namasoft.common.*;
import com.namasoft.common.constants.*;
import com.namasoft.common.fieldids.CommonFieldIds;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.flatobjects.tempo.ComplexRenderer;
import com.namasoft.common.hijri.HijriDate;
import com.namasoft.common.layout.metadata.ReportMetadata;
import com.namasoft.common.urlutils.*;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.translation.TranslationUtil;
import net.htmlparser.jericho.*;

import java.io.*;
import java.math.*;
import java.nio.charset.StandardCharsets;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.Base64;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import static com.namasoft.common.constants.JasperNamaSystemParameters.*;

@SuppressWarnings("unchecked")
public class ServerNamaRep extends StringUtils
{
	/**
	 * @param name1
	 * @param name2
	 * @return if Arabic name 1 else name 2
	 */
	public static Object name(Object name1, Object name2)
	{
		return name(name1, name2, lang());
	}

	public static Object nameOrCode(Object code, Object name1, Object name2)
	{
		if (ObjectChecker.isAnyNotEmptyOrNull(name1, name2))
			return name(name1, name2, lang());
		return code;
	}

	/**
	 * Translates the object
	 *
	 * @param o
	 * @return
	 */
	public static Object translate(Object o)
	{
		if (o == null)
			return "";
		if (o instanceof Boolean)
			return translate(((Boolean) o).booleanValue());
		return translate(ObjectChecker.toStringOrEmpty(o));
	}

	/**
	 * Translates a boolean
	 *
	 * @param b
	 * @return
	 */
	public static String translate(boolean b)
	{
		return translate("_" + b);
	}

	/**
	 * Translates a boolean
	 *
	 * @param b
	 * @return
	 */
	public static String translate(Boolean b)
	{
		if (b == null)
			return "";
		return translate(b.booleanValue());
	}

	/**
	 * Translates a string
	 *
	 * @param resourceId
	 * @return
	 */
	public static String translate(String resourceId)
	{
		return TranslationUtil.translate(lang(), resourceId);
	}

	/**
	 * Translates prefix+"."+value
	 *
	 * @param prefix
	 * @param value
	 * @return
	 */
	public static String translate(Object prefix, Object value)
	{
		if (ObjectChecker.isEmptyOrNull(value))
			return "";
		if (ObjectChecker.isEmptyOrNull(prefix))
			return tse(translate(value));
		return translate(prefix + "." + value);
	}

	/**
	 * Translates a field id
	 *
	 * @param entityType
	 * @param fieldId
	 * @return
	 */
	public static String title(Object entityType, Object fieldId)
	{
		return translate(entityType, fieldId);
	}

	/**
	 * @param reportParameters
	 * @param line
	 * @return
	 */
	public static String approveLink(Object reportParameters, Object line)
	{
		return approvalLink(reportParameters, line, ApprovalDecision.Approve);
	}

	public static String approveLink(Object reportParameters, Object line, Object reason)
	{
		return approvalLink(reportParameters, line, ApprovalDecision.Approve, reason);
	}

	/**
	 * @param reportParameters
	 * @param line
	 * @return
	 */
	public static String rejectLink(Object reportParameters, Object line)
	{
		return approvalLink(reportParameters, line, ApprovalDecision.Reject);
	}

	public static String rejectLink(Object reportParameters, Object line, Object reason)
	{
		return approvalLink(reportParameters, line, ApprovalDecision.Reject, reason);
	}

	/**
	 * @param reportParameters
	 * @param line
	 * @return
	 */
	public static String returnLink(Object reportParameters, Object line)
	{
		return approvalLink(reportParameters, line, ApprovalDecision.Return);
	}

	public static String returnLink(Object reportParameters, Object line, Object reason)
	{
		return approvalLink(reportParameters, line, ApprovalDecision.Return, reason);
	}

	/**
	 * @param reportParameters
	 * @return
	 */
	public static String approveAllLink(Object reportParameters)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), ApprovalDecision.Approve);
	}

	/**
	 * @param reportParameters
	 * @return
	 */
	public static String returnAllToPreviousStepLink(Object reportParameters)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), ApprovalDecision.ReturnToPreviousStep);
	}

	public static String returnAllToPreviousStepLink(Object reportParameters, Object reason)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), ApprovalDecision.ReturnToPreviousStep, reason);
	}

	/**
	 * @param reportParameters
	 * @return
	 */
	public static String returnToPreviousStepLink(Object reportParameters, Object line)
	{
		return approvalLink(reportParameters, line, ApprovalDecision.ReturnToPreviousStep);
	}

	public static String returnToPreviousStepLink(Object reportParameters, Object line, Object reason)
	{
		return approvalLink(reportParameters, line, ApprovalDecision.ReturnToPreviousStep, reason);
	}

	/**
	 * @param reportParameters
	 * @return
	 */
	private static HashMap<Object, Object> toMap(Object reportParameters)
	{
		return (HashMap<Object, Object>) reportParameters;
	}

	/**
	 * @param reportParameters
	 * @return
	 */
	public static String rejectAllLink(Object reportParameters)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), ApprovalDecision.Reject);
	}

	public static String rejectAllLink(Object reportParameters, Object reason)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), ApprovalDecision.Reject, reason);
	}

	/**
	 * @param reportParameters
	 * @return
	 */
	public static String returnAllLink(Object reportParameters)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), ApprovalDecision.Return);
	}

	public static String returnAllLink(Object reportParameters, Object reason)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), ApprovalDecision.Return,reason);
	}

	/**
	 * @param reportParameters
	 * @param decision
	 * @return
	 */
	public static String approveAllLink(Object reportParameters, Object decision)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), decision);
	}

	public static String approveAllLink(Object reportParameters, Object decision, Object reason)
	{
		return approvalLink(reportParameters, toMap(reportParameters).get(concernedLines), decision,reason);
	}

	/**
	 * @param reportParameters
	 * @param line
	 * @param decision
	 * @return
	 */
	public static String approvalLink(Object reportParameters, Object line, Object decision)
	{
		return approvalLink(reportParameters, line, decision, null);
	}

	public static String approvalLink(Object reportParameters, Object line, Object decision, Object reason)
	{
		return ServerApprovalUtils.approvalUrl(getApprovalGUIURL(reportParameters), decision, toMap(reportParameters).get(candidateEmployeeId), line,
				toMap(reportParameters).get(approvedRecordId), toMap(reportParameters).get(approvedRecordType),
				toMap(reportParameters).get(approvedRecordCode), toMap(reportParameters).get(approvalSecret),
				toMap(reportParameters).get(approvalStepSeq), reason);
	}

	/**
	 * @param reportParameters
	 * @param decision
	 * @param employeeId
	 * @param lines
	 * @param recordId
	 * @param recordType
	 * @param secret
	 * @param stepSeq
	 * @return
	 */
	public static String approvalLink(Object reportParameters, Object decision, Object employeeId, Object lines, Object recordId, Object recordType,
			Object secret, Object stepSeq)
	{
		return approvalLinkWithGUIURL(getApprovalGUIURL(reportParameters), decision, employeeId, lines, recordId, recordType, secret, stepSeq);
	}

	public static String approvalLink(Object reportParameters, Object decision, Object employeeId, Object lines, Object recordId, Object recordType,
			Object secret, Object stepSeq, Object reason)
	{
		return approvalLinkWithGUIURL(getApprovalGUIURL(reportParameters), decision, employeeId, lines, recordId, recordType, secret, stepSeq, reason);
	}

	/**
	 * @param guiServerURL
	 * @param decision
	 * @param employeeId
	 * @param lines
	 * @param recordId
	 * @param recordType
	 * @param secret
	 * @param stepSeq
	 * @return
	 */
	public static String approvalLinkWithGUIURL(Object guiServerURL, Object decision, Object employeeId, Object lines, Object recordId,
			Object recordType, Object secret, Object stepSeq)
	{
		return approvalLinkWithGUIURL(guiServerURL, decision, employeeId, lines, recordId, recordType, secret, stepSeq, null);
	}

	public static String approvalLinkWithGUIURL(Object guiServerURL, Object decision, Object employeeId, Object lines, Object recordId,
			Object recordType, Object secret, Object stepSeq, Object reason)
	{
		return ServerApprovalUtils
				.approvalUrl(ObjectChecker.toStringOrEmpty(guiServerURL), decision, employeeId, lines, recordId, recordType, "", secret, stepSeq,
						reason);
	}

	/**
	 * @param reportParameters
	 * @return
	 */
	private static String getApprovalGUIURL(Object reportParameters)
	{
		return ObjectChecker
				.getFirstNotEmptyObj(ObjectChecker.toStringOrEmpty(toMap(reportParameters).get("guiurl")), GeneralSettings.getApprovalsLink(),
						NaMaLayersConnector.getInstance().getGuiServerURL());
	}

	/**
	 * @param entityType
	 * @param id
	 * @return
	 */
	public static String link(Object entityType, Object id)
	{
		return link(NaMaLayersConnector.getInstance().getGuiServerURL(), entityType, id);
	}

	public static String attachmentLink(Object id)
	{
		return attachmentLink(NaMaLayersConnector.getInstance().getGuiServerURL(), id);
	}

	public static String attachmentLink(String url, Object id)
	{
		if (ObjectChecker.isEmptyOrNull(id))
			return "";
		id = convertIdIfNeeded(id);
		if (ObjectChecker.isNotEmptyOrNull(url) && !url.endsWith("/"))
			url += "/";
		return url + PlaceTokens.linkToFile(ObjectChecker.toStringOrEmpty(id), DomainBaseEntities.DocumentBook,
				NaMaLayersConnector.getInstance().getAttachmentFileNameIfPossible(ObjectChecker.toStringOrEmpty(id)));
	}

	public static ListViewUrlBuilder listView()
	{
		return new ListViewUrlBuilder();
	}

	public static String toUUIDString(Object id)
	{
		return ObjectChecker.toStringOrEmpty(convertIdIfNeeded(id));
	}

	/**
	 * @param url
	 * @param entityType
	 * @param id
	 * @return
	 */
	public static String link(String url, Object entityType, Object id)
	{
		id = convertIdIfNeeded(id);
		return url + PlaceTokens.getEditPlaceToken(entityType + "", id + "", ViewMode.EDIT);
	}

	private static Object convertIdIfNeeded(Object id)
	{
		if (id == null)
			return id;
		if (id.getClass().isArray())
		{
			byte[] bytes = (byte[]) id;
			id = ServerCommonUtils.byteArrayToUUID(bytes);
		}
		return id;
	}

	/**
	 * @param name1
	 * @param name2
	 * @param lang
	 * @return
	 */
	public static Object name(Object name1, Object name2, Language lang)
	{
		return isEnglish(lang) ? ObjectChecker.getFirstNotEmptyObj(name2, name1) : ObjectChecker.getFirstNotEmptyObj(name1, name2);
	}

	/**
	 * @param lang
	 * @return
	 */
	public static boolean isEnglish(Language lang)
	{
		return lang == Language.English;
	}

	/**
	 * @return
	 */
	public static Language lang()
	{
		return TranslationUtil.getCurrentLanguage();
	}

	/**
	 * @param resourceId
	 * @return
	 */
	public static String sub(String resourceId)
	{
		String translated = translate(resourceId);
		String[] parts = translated.split(Pattern.quote("|"));
		if (parts.length > 1)
			return parts[1];
		return translated;
	}

	/**
	 * @param resourceId
	 * @return
	 */
	public static String head(String resourceId)
	{
		String translated = translate(resourceId);
		String[] parts = translated.split(Pattern.quote("|"));
		if (parts.length > 1)
			return parts[0];
		return translated;
	}

	/**
	 * @param currencyCode
	 * @param value
	 * @return
	 */
	public static String tafqeet(Object currencyCode, Object value)
	{
		value = objectToDecimal(value);
		return com.namasoft.common.utils.tafqeet.Converter.convertToWords((BigDecimal) value, ObjectChecker.toStringOrEmpty(currencyCode), TranslationUtil.getCurrentLanguage());
	}

	public static String tafqeetEnglish(Object currencyCode, Object value)
	{
		value = objectToDecimal(value);
		return com.namasoft.common.utils.tafqeet.Converter.convertToWords((BigDecimal) value, ObjectChecker.toStringOrEmpty(currencyCode), Language.English);
	}
	public static String tafqeetFrench(Object currencyCode, Object value)
	{
		value = objectToDecimal(value);
		return com.namasoft.common.utils.tafqeet.Converter.convertToFrench((BigDecimal) value, ObjectChecker.toStringOrEmpty(currencyCode));
	}
	public static String tafqeetArabic(Object currencyCode, Object value)
	{
		value = objectToDecimal(value);
		return com.namasoft.common.utils.tafqeet.Converter.convertToWords((BigDecimal) value, ObjectChecker.toStringOrEmpty(currencyCode), Language.Arabic);
	}

	/**
	 * @param value
	 * @return
	 */
	public static BigDecimal objectToDecimal(Object value)
	{
		if (ObjectChecker.isEmptyOrNull(value))
			value = BigDecimal.ZERO;
		if (!(value instanceof BigDecimal))
			value = new BigDecimal(value.toString());
		return (BigDecimal) value;
	}

	/**
	 * @param value
	 * @return
	 */
	public static String decryptStr(String value)
	{
		if (ObjectChecker.isEmptyOrNull(value))
			return "";
		return CryptoUtils.decrypt(value);
	}

	public static String expandSerials(Object serials)
	{
		return expandSerials(serials, "\n");
	}

	public static String expandSerials(Object oSerials, Object oSeparator)
	{
		String serials = ObjectChecker.toStringOrEmpty(oSerials);
		if (ObjectChecker.isEmptyOrNull(serials))
			return "";
		String separator = ObjectChecker.toStringOrEmpty(oSeparator);
		return ItemSerialNumberUtil.unZipSerials(serials).stream().collect(Collectors.joining(separator));
	}

	/**
	 * @param itemCode
	 * @return
	 */
	public static BigDecimal getItemPriceByCode(Object itemCode)
	{
		return NaMaLayersConnector.getInstance().getItemPriceByCode(itemCode);
	}

	/**
	 * @param itemId
	 * @return
	 */
	public static BigDecimal getItemPriceById(Object itemId)
	{
		return NaMaLayersConnector.getInstance().getItemPriceById(itemId);
	}

	/**
	 *
	 * @param itemCode
	 * @return
	 */
	public static BigDecimal getNetPurchaseValue(Object itemCode)
	{
		return NaMaLayersConnector.getInstance().getNetPurchaseValue(itemCode);
	}

	/**
	 * @param item
	 * @param customer
	 * @return
	 */
	public static BigDecimal getItemPriceForCustomer(Object item, Object customer)
	{
		return NaMaLayersConnector.getInstance().getItemPriceForCustomer(item, customer);
	}

	/**
	 *
	 * @param itemIdOrCode
	 * @param customerIdOrCode
	 * @param uom
	 * @param qty
	 * @param classificationIdOrCode
	 * @return
	 */
	public static Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode)
	{
		return NaMaLayersConnector.getInstance().getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty, classificationIdOrCode);
	}

	public static Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
			Object date)
	{
		return NaMaLayersConnector.getInstance().getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty, classificationIdOrCode, date);
	}

	public static Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
			Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode, Object analysisSetIdOrCode,
			Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode)
	{
		return NaMaLayersConnector.getInstance()
				.getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty, classificationIdOrCode, date, legalEntityIdOrCode, sectorIdOrCode,
						branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode, sizeCode);
	}

	public static ItemPriceCalculator priceCalculator()
	{
		return NaMaLayersConnector.getInstance().createPriceCalculator();
	}

	public static Object getPricesForCustomer(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
			Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
			Object priceClassifier5IdOrCode)
	{
		return NaMaLayersConnector.getInstance()
				.getPricesForCustomer(parametersMap, itemIdOrCode, customerIdOrCode, oUom, oQty, classificationIdOrCode, date, legalEntityIdOrCode,
						sectorIdOrCode, branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode, sizeCode,
						priceClassifier1IdOrCode, priceClassifier2IdOrCode, priceClassifier3IdOrCode, priceClassifier4IdOrCode,
						priceClassifier5IdOrCode);
	}

	public static Object getPurchasePricesForSupplier(Map parametersMap, Object itemIdOrCode, Object supplierIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
			Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
			Object priceClassifier5IdOrCode)
	{
		return NaMaLayersConnector.getInstance()
				.getPurchasePricesForSupplier(parametersMap, itemIdOrCode, supplierIdOrCode, oUom, oQty, classificationIdOrCode, date,
						legalEntityIdOrCode, sectorIdOrCode, branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode,
						sizeCode, priceClassifier1IdOrCode, priceClassifier2IdOrCode, priceClassifier3IdOrCode, priceClassifier4IdOrCode,
						priceClassifier5IdOrCode);
	}

	public static Object getPricesForCustomer(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode)
	{
		return NaMaLayersConnector.getInstance()
				.getPricesForCustomer(parametersMap, itemIdOrCode, customerIdOrCode, oUom, oQty, classificationIdOrCode, date, legalEntityIdOrCode,
						sectorIdOrCode, branchIdOrCode, analysisSetIdOrCode, departmentIdOrCode, revisionIdCode, colorCode, sizeCode);
	}

	public static Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
			Object date, Object legalEntityIdOrCode)
	{
		return NaMaLayersConnector.getInstance()
				.getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty, classificationIdOrCode, date, legalEntityIdOrCode);
	}
	/**
	 * @param itemIdOrCode
	 * @param customerIdOrCode
	 * @param uom
	 * @param qty
	 * @return
	 */

	public static Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty)
	{
		return NaMaLayersConnector.getInstance().getPricesForCustomer(itemIdOrCode, customerIdOrCode, uom, qty);
	}

	/**
	 * @param itemIdOrCode
	 * @param customerIdOrCode
	 * @return
	 */
	public static Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode)
	{
		return NaMaLayersConnector.getInstance().getPricesForCustomer(itemIdOrCode, customerIdOrCode);
	}

	/**
	 * @param item
	 * @param customer
	 * @param discountIndex
	 * @return
	 */
	public static BigDecimal getItemDiscountForCustomer(Object item, Object customer, Object discountIndex)
	{
		return NaMaLayersConnector.getInstance().getItemDiscountForCustomer(item, customer, discountIndex);
	}

	/**
	 * @param reportParameters
	 * @param oLineIndex
	 * @return
	 */
	public static Boolean isConcernedLine(Object reportParameters, Object oLineIndex)
	{
		String theConcernedLines = (String) toMap(reportParameters).get(concernedLines);
		if (ObjectChecker.isEmptyOrNull(theConcernedLines) || ApprovalUtils.headerApproval(theConcernedLines))
			return true;
		Integer lineIndex;
		if (oLineIndex instanceof Integer)
			lineIndex = (Integer) oLineIndex;
		else
			lineIndex = ObjectChecker.valueOfInteger(ObjectChecker.toStringOrEmpty(oLineIndex));
		return ApprovalUtils.calcIndices(theConcernedLines).contains(lineIndex);
	}
	private static final char[] arNumbersArray = { '٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩' };
	private static final char[] enNumbersArray = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };

	/**
	 * @param oStr
	 * @return
	 */
	public static String arNumbers(Object oStr)
	{
		String str = ObjectChecker.toStringOrEmpty(oStr);
		for (int i = 0; i < arNumbersArray.length; i++)
		{
			str = str.replace(enNumbersArray[i], arNumbersArray[i]);
		}
		return str;
	}

	/**
	 * @param reportParameters
	 * @param code
	 * @return
	 */
	public static ReportQuestions repLinkByCode(Object reportParameters, Object code)
	{
		return repLinkByCode(reportParameters, code, false);
	}

	/**
	 * @param reportParameters
	 * @param code
	 * @param performChecks
	 * @return
	 */
	public static ReportQuestions repLinkByCode(Object reportParameters, Object code, boolean performChecks)
	{
		String codeOrId = ObjectChecker.toStringOrEmpty(code);
		return repLinkByCodeOrId(performChecks, reportParameters, true, codeOrId);
	}

	/**
	 * @param reportParameters
	 * @param id
	 * @return
	 */
	public static ReportQuestions repLinkById(Object reportParameters, Object id)
	{
		return repLinkById(reportParameters, id, false);
	}

	/**
	 * @param reportParameters
	 * @param id
	 * @param performChecks
	 * @return
	 */
	public static ReportQuestions repLinkById(Object reportParameters, Object id, boolean performChecks)
	{
		if (id.getClass().isArray())
			id = ServerCommonUtils.byteArrayToUUID((byte[]) id);
		return repLinkByCodeOrId(performChecks, reportParameters, false, ObjectChecker.toStringOrEmpty(id));
	}

	/**
	 * @param performChecks
	 * @param reportParameters
	 * @param useCode
	 * @param codeOrId
	 * @return
	 */
	private static ReportQuestions repLinkByCodeOrId(boolean performChecks, Object reportParameters, boolean useCode, String codeOrId)
	{
		String metadataKey = "REPRT_METADATA_" + codeOrId.toLowerCase();
		SimpleEntry<EntityReferenceData, ReportMetadata> reportMetadata = (SimpleEntry<EntityReferenceData, ReportMetadata>) toMap(
				reportParameters).get(metadataKey);
		if (reportMetadata == null)
		{
			if (useCode)
				reportMetadata = NaMaLayersConnector.getInstance().findReportMetadataByCode(codeOrId);
			else
				reportMetadata = NaMaLayersConnector.getInstance().findReportMetadataById(codeOrId);
			toMap(reportParameters).put(metadataKey, reportMetadata);
		}
		if (reportMetadata == null)
		{
			reportMetadata = new SimpleEntry<>(new EntityReferenceData(BSCEntities.ReportDefinition, codeOrId, codeOrId), new ReportMetadata());
			NaMaLogger.error(new RuntimeException("Could not find report with code " + codeOrId));
		}
		return new ReportQuestions(reportMetadata.getValue(), reportMetadata.getKey(), performChecks, toMap(reportParameters));
	}

	/**
	 * @param o
	 * @return
	 */
	public static boolean canDisplay(Object o)
	{
		return NaMaLayersConnector.getInstance().canDisplay(o);
	}

	/**
	 * @param query
	 * @param parameters
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static List runSQLQuery(String query, Object... parameters)
	{
		return NaMaLayersConnector.getInstance().runSQLQuery(query, parameters);
	}

	/**
	 * @param o
	 * @return
	 */
	public static List<List<String>> getKeyValue(Object o)
	{
		String str = ObjectChecker.toStringOrEmpty(o);
		String[] parts = str.split(CommonConstants.SEPARATOR);
		List<List<String>> list = new ArrayList<List<String>>();
		for (String part : parts)
		{
			String[] keyValue = part.split(":");
			if (ObjectChecker.isEmptyOrNull(keyValue) || keyValue.length < 2)
				continue;
			list.add(Arrays.asList(keyValue));
		}
		return list;
	}

	/**
	 * @param o
	 * @return
	 */
	public static List<String> getKeys(Object o)
	{
		List<List<String>> keyValue = getKeyValue(o);
		return CollectionsUtility.convert(keyValue, new com.namasoft.common.utilities.Converter<List<String>, String>()
		{
			@Override
			public String convert(List<String> object)
			{
				return object.get(0);
			}
		});
	}

	/**
	 * @param o
	 * @return
	 */
	public static List<String> getValues(Object o)
	{
		List<List<String>> keyValue = getKeyValue(o);
		return CollectionsUtility.convert(keyValue, new com.namasoft.common.utilities.Converter<List<String>, String>()
		{
			@Override
			public String convert(List<String> object)
			{
				return object.get(1);
			}
		});
	}

	/**
	 * @param queryResult
	 * @param rowSep
	 * @param columnSep
	 * @return
	 */
	public static String formatQueryResult(List<?> queryResult, String rowSep, String columnSep)
	{
		StringBuilder builder = new StringBuilder();
		for (int i = 0; i < queryResult.size(); i++)
		{
			Object row = queryResult.get(i);
			if (row == null)
				continue;
			if (row.getClass().isArray())
			{
				Object[] arr = (Object[]) row;
				builder.append(toCSVLineWithSep(columnSep, arr));
			}
			else
			{
				builder.append(ObjectChecker.toStringOrEmpty(row));
			}
			if (i < queryResult.size() - 1)
				builder.append(rowSep);
		}
		return builder.toString();
	}

	public static InputStream getAttachment(Object id) throws Exception
	{
		return getFile(id);
	}

	/**
	 * @param id
	 * @return
	 * @throws Exception
	 */
	public static InputStream getFile(Object id) throws Exception
	{
		try
		{
			return NaMaLayersConnector.getInstance().getFile(id);
		}
		catch (Exception e)
		{
			if (LoggingConfigurator.isInDebugMode())
			{
				NaMaLogger.error(e);
				return null;
			}
			else
			{
				throw e;
			}
		}
	}

	/**
	 * @param entityType
	 * @param id
	 * @param versionNumber
	 * @param actionType
	 * @return
	 */
	public static String audit(Object entityType, Object id, Object versionNumber, Object actionType, String language, String outputFormat)
	{
		return NaMaLayersConnector.getInstance()
				.audit(entityType, id, versionNumber, actionType, "english".equalsIgnoreCase(language) ? Language.English : Language.Arabic,
						"html".equalsIgnoreCase(outputFormat) ? OutputFormat.HTML : OutputFormat.TXT);
	}

	/**
	 * @param date
	 * @return
	 */
	public static String toHijri(Date date)
	{
		if (date == null)
			return "";
		return NaMaLayersConnector.getInstance().toHijri(date);
	}

	public static HijriDate toHijriDate(Date date)
	{
		if (date == null)
			return null;
		return NaMaLayersConnector.getInstance().toHijriDate(date);
	}

	public static String hijriDay(Date date)
	{
		if (date == null)
			return null;
		return ServerStringUtils.leftPad(NaMaLayersConnector.getInstance().toHijriDate(date).getD(), 2);
	}

	public static String hijriMonth(Date date)
	{
		if (date == null)
			return null;
		return ServerStringUtils.leftPad(NaMaLayersConnector.getInstance().toHijriDate(date).getM(), 2);
	}

	public static String hijriYear(Date date)
	{
		if (date == null)
			return null;
		return ServerStringUtils.leftPad(NaMaLayersConnector.getInstance().toHijriDate(date).getM(), 4);
	}

	public static String hijri_yyyyMMdd(Date date)
	{
		if (date == null)
			return "";
		HijriDate h = NaMaLayersConnector.getInstance().toHijriDate(date);
		return h.getY() + ServerStringUtils.leftPad(h.getM(), 2) + ServerStringUtils.leftPad(h.getD(), 2);
	}

	/**
	 * @param date
	 * @return
	 */
	@SuppressWarnings("deprecation")
	public static String toHijri(Object date)
	{
		if (date instanceof Date)
			return NaMaLayersConnector.getInstance().toHijri((Date) date);
		if (date == null)
			return "";
		return NaMaLayersConnector.getInstance().toHijri(new Date(date.toString()));
	}

	/**
	 * @param o
	 * @return
	 */
	public static String decimalToTimeNullable(Object o)
	{
		String decimalToTime = decimalToTime(o);
		return decimalToTime.equals("00:00") ? null : decimalToTime;
	}

	/**
	 * @param o
	 * @return
	 */
	public static String timeToStringNullable(Object o)
	{
		BigDecimal d = objectToDecimal(o);
		return decimalToTimeNullable(NaMaMath.divide(d, new BigDecimal(3600000), 32));
	}

	public static String timeToString(Object o)
	{
		BigDecimal d = objectToDecimal(o);
		return decimalToTime(NaMaMath.divide(d, new BigDecimal(3600000), 32));
	}

	/**
	 * @param o
	 * @return
	 */
	public static String decimalToTime(Object o)
	{
		BigDecimal d = objectToDecimal(o);
		int hours = d.intValue();
		int minutes = d.subtract(new BigDecimal(hours)).multiply(new BigDecimal(60)).intValue();
		String hoursStr = (hours < 10 ? "0" : "") + hours;
		String minutesStr = (minutes < 10 ? "0" : "") + minutes;
		return hoursStr + ":" + minutesStr;
	}

	/**
	 * @param entityType
	 * @param entityId
	 * @param nextStepName
	 * @param concernedLines
	 * @param nextStepSeq
	 * @return
	 */
	public static String approveFromJS(Object entityType, Object entityId, Object nextStepName, Object concernedLines, Object nextStepSeq)
	{
		return approveFromJS(entityType, entityId, nextStepName, concernedLines, nextStepSeq, null, null, null);
	}

	/**
	 * @param entityType
	 * @param entityId
	 * @param nextStepName
	 * @param concernedLines
	 * @param nextStepSeq
	 * @param summary
	 * @return
	 */
	public static String approveFromJS(Object entityType, Object entityId, Object nextStepName, Object concernedLines, Object nextStepSeq,
			Object summary)
	{
		return approveFromJS(entityType, entityId, nextStepName, concernedLines, nextStepSeq, summary, null, null);
	}

	/**
	 * @param entityType
	 * @param entityId
	 * @param nextStepName
	 * @param concernedLines
	 * @param nextStepSeq
	 * @param summary
	 * @param defaultDecision
	 * @return
	 */
	public static String approveFromJS(Object entityType, Object entityId, Object nextStepName, Object concernedLines, Object nextStepSeq,
			Object summary, Object defaultDecision)
	{
		return approveFromJS(entityType, entityId, nextStepName, concernedLines, nextStepSeq, summary, defaultDecision, null);
	}

	/**
	 * @param entityType
	 * @param entityId
	 * @param nextStepName
	 * @param concernedLines
	 * @param nextStepSeq
	 * @param summary
	 * @param defaultDecision
	 * @param fields
	 * @return
	 */
	public static String approveFromJS(Object entityType, Object entityId, Object nextStepName, Object concernedLines, Object nextStepSeq,
			Object summary, Object defaultDecision, Object fields)
	{
		return "javascript://window.parent.showApprovalView('" + tse(entityType) + "','" + ServerStringUtils.toUUIDStr(entityId) + "','" + tse(
				nextStepName) + "','" + tse(concernedLines) + "'," + nextStepSeq + ",'" + tse(summary) + "','" + tse(defaultDecision) + "','" + tse(
				fields) + "');";
	}

	/**
	 * @param o
	 * @return
	 */
	private static String tse(Object o)
	{
		return ObjectChecker.toStringOrEmpty(o);
	}

	/**
	 * @param html
	 * @return
	 */
	public static String htmlToText(Object html)
	{
		Source htmlSource = new Source(ObjectChecker.toStringOrEmpty(html));
		Segment htmlSeg = new Segment(htmlSource, 0, htmlSource.length());
		Renderer htmlRend = new Renderer(htmlSeg);
		return htmlRend.toString();
	}

	/**
	 * @param empCodeOrId
	 * @return
	 */
	public static BigDecimal getVacation1RemainderBalance(Object empCodeOrId)
	{
		return NaMaLayersConnector.getInstance().getVacation1RemainderBalance(empCodeOrId);
	}

	public static BigDecimal getVacationRemainderBalance(Object empCodeOrId, Object vacationTypeIdOrCode)
	{
		return NaMaLayersConnector.getInstance().getVacationRemainderBalance(empCodeOrId, vacationTypeIdOrCode, null);
	}

	public static Triple<BigDecimal, Pair<BigDecimal, BigDecimal>, BigDecimal> getVacationAssignedConsumedRemainder(Object empCodeOrId,
			Object vacationTypeCodeOrId)
	{
		return getVacationAssignedConsumedRemainder(empCodeOrId, vacationTypeCodeOrId, null);
	}

	public static List<BigDecimal> getRemainderBalancePerYears(Object empCodeOrId, Object atDate, Object yearsCount)
	{
		return getRemainderBalancePerYears(empCodeOrId, null, atDate, yearsCount);
	}

	public static List<BigDecimal> getRemainderBalancePerYears(Object empCodeOrId, Object typeCodeOrId, Object atDate, Object yearsCount)
	{
		return NaMaLayersConnector.getInstance().getRemainderBalancePerYears(empCodeOrId, typeCodeOrId, atDate, yearsCount);
	}

	public static Triple<BigDecimal, Pair<BigDecimal, BigDecimal>, BigDecimal> getVacationAssignedConsumedRemainder(Object empCodeOrId,
			Object vacationTypeCodeOrId, Object atDate)
	{
		return getVacationAssignedConsumedRemainder(null, empCodeOrId, vacationTypeCodeOrId, atDate);
	}

	public static Triple<BigDecimal, Pair<BigDecimal, BigDecimal>, BigDecimal> getVacationAssignedConsumedRemainder(Map map, Object empCodeOrId,
			Object vacationTypeCodeOrId, Object atDate)
	{
		Triple<Object, Object, Object> key = new Triple<>(empCodeOrId, vacationTypeCodeOrId, atDate);
		if (map != null && map.containsKey(key))
			return (Triple<BigDecimal, Pair<BigDecimal, BigDecimal>, BigDecimal>) map.get(key);
		Triple<BigDecimal, Pair<BigDecimal, BigDecimal>, BigDecimal> remainder = NaMaLayersConnector.getInstance()
				.getVacationAssignedConsumedRemainder(empCodeOrId, vacationTypeCodeOrId, atDate);
		if (map != null)
			map.put(key, remainder);
		return remainder;
	}

	public static BigDecimal getVacationRemainderBalance(Object empCodeOrId, Object vacationTypeIdOrCode, Object atDate)
	{
		return NaMaLayersConnector.getInstance().getVacationRemainderBalance(empCodeOrId, vacationTypeIdOrCode, atDate);
	}

	/**
	 * @param empCodeOrId
	 * @return
	 */
	public static BigDecimal getVacation2RemainderBalance(Object empCodeOrId)
	{
		return NaMaLayersConnector.getInstance().getVacation2RemainderBalance(empCodeOrId);
	}

	/**
	 * @param empCodeOrId
	 * @return
	 */
	public static BigDecimal getVacation3RemainderBalance(Object empCodeOrId)
	{
		return NaMaLayersConnector.getInstance().getVacation3RemainderBalance(empCodeOrId);
	}

	/***
	 *
	 * @return
	 */
	public static ValuesHolder holder()
	{
		return new ValuesHolder();
	}

	/***
	 *
	 * @param entityType
	 * @return
	 */
	public static ReportNewCreator newWithFields(Object entityType)
	{
		return new ReportNewCreator().entity(entityType);
	}

	/***
	 *
	 * @param entityType
	 * @return
	 */
	public static ReportNewCreator creator(Object entityType)
	{
		return new ReportNewCreator().entity(entityType);
	}

	private static String[] enDayNames = { "", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" };
	private static String[] arDayNames = { "", "الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت" };

	public static String dayName(Object dateOrNumber)
	{
		return calcDayName(dateOrNumber, enDayNames);
	}

	public static String enDayName(Object dateOrNumber)
	{
		return calcDayName(dateOrNumber, enDayNames);
	}

	/***
	 *
	 * @param dateOrNumber
	 * @return
	 */
	public static String arDayName(Object dateOrNumber)
	{
		return calcDayName(dateOrNumber, arDayNames);
	}

	/***
	 *
	 * @param dateOrNumber
	 * @param dayNames
	 * @return
	 */
	public static String calcDayName(Object dateOrNumber, String[] dayNames)
	{
		if (ObjectChecker.isEmptyOrNull(dateOrNumber))
			return "";
		if (dateOrNumber instanceof Date)
		{
			Calendar cal = Calendar.getInstance();
			cal.setTime((Date) dateOrNumber);
			return dayNames[cal.get(Calendar.DAY_OF_WEEK)];
		}
		Integer dw = ObjectChecker.tryParseInt(ObjectChecker.toStringOrEmpty(dateOrNumber));
		if (dw == null || dw < 0 || dw > 7)
			return "";
		return dayNames[dw];
	}

	/***
	 *
	 * @param moduleId
	 * @param fieldId
	 * @return
	 */
	public static Object getValueFromModuleConfig(Object moduleId, Object fieldId)
	{
		return NaMaLayersConnector.getInstance()
				.getValueFromModuleConfig(ObjectChecker.toStringOrEmpty(moduleId), ObjectChecker.toStringOrEmpty(fieldId));
	}

	public static BigDecimal round(BigDecimal v, Integer scale)
	{
		return NaMaMath.round(v, scale);
	}

	public static LinkCreator link()
	{
		return new LinkCreator();
	}

	public static class LinkCreator
	{
		private Object id;
		private Object entityType;
		private Object menuCode;
		private Object viewName;
		private Object url;

		public LinkCreator id(Object id)
		{
			this.id = id;
			return this;
		}

		public LinkCreator entityType(Object entityType)
		{
			this.entityType = entityType;
			return this;
		}

		public LinkCreator menuCode(Object menuCode)
		{
			this.menuCode = menuCode;
			return this;
		}

		public LinkCreator viewName(Object viewName)
		{
			this.viewName = viewName;
			return this;
		}

		public LinkCreator url(Object url)
		{
			this.url = url;
			return this;
		}

		@Override
		public String toString()
		{
			if (ObjectChecker.isEmptyOrNull(url))
				url = NaMaLayersConnector.getInstance().getGuiServerURL();
			return url + PlaceTokens
					.getEditPlaceToken(ObjectChecker.toStringOrEmpty(entityType), idToStr(id), ViewMode.EDIT, ObjectChecker.toStringOrNull(viewName),
					ObjectChecker.toStringOrNull(menuCode));
		}
	}

	public static NaMaMath math = new NaMaMath();
	public static ServerStringUtils strUtils = new ServerStringUtils();

	public static String idToStr(Object id)
	{
		return ServerStringUtils.toUUIDStr(id);
	}

	public static String currencyPattern()
	{
		return NaMaLayersConnector.getInstance().currencyPattern(null);
	}

	public static String currencyPattern(Object currencyCodeOrId)
	{
		return NaMaLayersConnector.getInstance().currencyPattern(currencyCodeOrId);
	}

	public static String currencyOrQtyPattern(Object currencyOrQtyCodeOrId)
	{
		return NaMaLayersConnector.getInstance().currencyOrQtyPattern(currencyOrQtyCodeOrId);
	}

	public static String quantityPattern()
	{
		return NaMaLayersConnector.getInstance().quantityPattern(null);
	}

	public static String ratePattern()
	{
		return NaMaLayersConnector.getInstance().ratePattern();
	}

	public static String percentPattern()
	{
		return NaMaLayersConnector.getInstance().percentPattern();
	}

	public static String datePattern()
	{
		return NaMaLayersConnector.getInstance().datePattern();
	}

	public static String timePattern()
	{
		return NaMaLayersConnector.getInstance().timePattern();
	}

	public static String dateTimePattern()
	{
		return NaMaLayersConnector.getInstance().dateTimePattern();
	}

	public static String quantityPattern(Object uomCodeOrId)
	{
		return NaMaLayersConnector.getInstance().quantityPattern(uomCodeOrId);
	}

	public static List<String> unzipSerials(Object serials)
	{
		return NaMaLayersConnector.getInstance().unzipSerials(serials);
	}

	public static String zipSerialsRange(Object serials)
	{
		return ItemSerialNumberUtil.zipSerialRange(ItemSerialNumberUtil.unZipSerials(ObjectChecker.toStringOrEmpty(serials)));
	}

	public static String unzipSerialsWithNewLines(Object serials)
	{
		return unzipSerialsWithSeparator(serials, "\n");
	}

	public static String unzipSerialsWithComma(Object serials)
	{
		return unzipSerialsWithSeparator(serials, ",");
	}

	public static String unzipSerialsWithSeparator(Object serials, String separator)
	{
		return NaMaLayersConnector.getInstance().unzipSerials(serials).stream().collect(Collectors.joining(separator));
	}

	public static String retrieverFileId(Object entityType, Object idOrCode)
	{
		return NaMaLayersConnector.getInstance().retrieverFileId(entityType, idOrCode);
	}

	private static final DateTimeFormatter ZATCA_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
	private static final DateTimeFormatter ZATCA_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
	private static final DateTimeFormatter ZATCA_TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");

	public static void main(String[] args)
	{
		GregorianCalendar calendar = new GregorianCalendar();
		calendar.set(Calendar.YEAR, 2022);
		calendar.set(Calendar.MONTH, Calendar.APRIL);
		calendar.set(Calendar.DAY_OF_MONTH, 25);
		calendar.set(Calendar.HOUR_OF_DAY, 15);
		calendar.set(Calendar.MINUTE, 30);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		Date timeStamp = calendar.getTime();
		System.out.println(genZATCAQR("Bobs Records", "310122393500003", timeStamp, new BigDecimal("10000.00"), new BigDecimal("150.00")));
		System.out.println("AQxCb2JzIFJlY29yZHMCDzMxMDEyMjM5MzUwMDAwMwMUMjAyMi0wNC0yNVQxNTozMDowMFoEBzEwMDAuMDAFBjE1MC4wMA==");
	}

	public static String genZATCAQRWithCreationDate(String sellerName, String vatNumber, Date valueDate, Date creationDate, BigDecimal invoiceAmount,
			BigDecimal vatAmount)
	{
		Date now = new Date();
		valueDate = ObjectChecker.getFirstNotNullObj(valueDate, creationDate, now);
		valueDate = new Date(valueDate.getTime());
		creationDate = ObjectChecker.getFirstNotNullObj(creationDate, valueDate, now);
		creationDate = new Date(creationDate.getTime());
		LocalDateTime valueLdt = LocalDateTime.ofInstant(valueDate.toInstant(), ZoneId.systemDefault());
		LocalDateTime creationLdt = LocalDateTime.ofInstant(creationDate.toInstant(), ZoneId.systemDefault());
		return genZATCAQRWithDateStr(sellerName, vatNumber, ZATCA_DATE_FORMAT.format(valueLdt) + "T" + ZATCA_TIME_FORMAT.format(creationLdt) + "Z",
				invoiceAmount, vatAmount);
	}

	public static String genZATCAQR(String sellerName, String vatNumber, Date timeStamp, BigDecimal invoiceAmount, BigDecimal vatAmount)
	{
		timeStamp = ObjectChecker.getFirstNotNullObj(timeStamp, new Date());
		timeStamp = new Date(timeStamp.getTime());
		LocalDateTime ldt = LocalDateTime.ofInstant(timeStamp.toInstant(), ZoneId.systemDefault());
		return genZATCAQRWithDateStr(sellerName, vatNumber, ZATCA_TIMESTAMP_FORMAT.format(ldt) + "Z", invoiceAmount, vatAmount);
	}

	public static String genZATCAQRWithDateStr(String sellerName, String vatNumber, String timeStamp, BigDecimal invoiceAmount, BigDecimal vatAmount)
	{
		try
		{
			ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
			addZATCAPart(sellerName, outputStream, (byte) 1);
			addZATCAPart(vatNumber, outputStream, (byte) 2);
			addZATCAPart(timeStamp, outputStream, (byte) 3);
			addZATCAPart(invoiceAmount, outputStream, (byte) 4);
			addZATCAPart(vatAmount, outputStream, (byte) 5);

			return Base64.getEncoder().encodeToString(outputStream.toByteArray());
		}
		catch (Exception e)
		{
			throw new RuntimeException(e);
		}
	}

	public static void addZATCAPart(BigDecimal value, ByteArrayOutputStream outputStream, byte tagName) throws IOException
	{
		value = ObjectChecker.toZeroIfNull(value);
		value.setScale(2, RoundingMode.HALF_UP);
		addZATCAPart(value.toPlainString(), outputStream, tagName);
	}

	public static void addZATCAPart(String value, ByteArrayOutputStream outputStream, byte tagName) throws IOException
	{
		value = ObjectChecker.toStringOrEmpty(value);
		byte[] tag = { tagName };
		outputStream.write(tag);
		byte[] b_value = value.getBytes(StandardCharsets.UTF_8);
		tag[0] = (byte) b_value.length;
		outputStream.write(tag);
		outputStream.write(b_value);
	}

	public static class OrderByData
	{
		private List<String> orderByParameterTitles;
		private List<String> groupsSort;
		private List<String> orderByParameterColumns;
		private List<String> orderByDirections;
		private List<String> selectedOrderBy;
		private List<String> selectedSortDirections;
		private Map<String, List<String>> sortsByGroupName;
		private String selectedGroupName;
		private boolean columnsBeforeGroupFields = false;
		public OrderByData orderByParameterTitles(String... titles)
		{
			orderByParameterTitles = Arrays.asList(titles);
			return this;
		}

		public OrderByData groupsSort(String... titles)
		{
			groupsSort = Arrays.asList(titles);
			return this;
		}

		public OrderByData sortsByGroupName(Map<String, List<String>> sortsByGroupName)
		{
			this.sortsByGroupName = sortsByGroupName;
			return this;
		}

		public OrderByData selectedGroupName(String selectedGroupName)
		{
			this.selectedGroupName = selectedGroupName;
			return this;
		}

		public OrderByData orderByParameterColumns(String... columns)
		{
			orderByParameterColumns = Arrays.asList(columns);
			return this;
		}

		public OrderByData orderByDirections(String... directions)
		{
			orderByDirections = Arrays.asList(directions);
			return this;
		}

		public OrderByData selectedOrderBy(String... orderBy)
		{
			selectedOrderBy = Arrays.asList(orderBy);
			return this;
		}

		public OrderByData selectSortDirections(String... directions)
		{
			selectedSortDirections = Arrays.asList(directions);
			return this;
		}

		public OrderByData setColumnsBeforeGroupFields(boolean value)
		{
			columnsBeforeGroupFields = value;
			return this;
		}

		@Override
		public String toString()
		{
			if (ObjectChecker.areAllEmptyOrNull(selectedOrderBy, groupsSort, sortsByGroupName))
				return "";
			List<String> orderByColumns;
			if (ObjectChecker.isAnyEmptyOrNull(orderByParameterTitles, orderByParameterColumns))
				orderByColumns = selectedOrderBy;
			else
				orderByColumns = selectedOrderBy.stream().map(s -> orderByParameterColumns.get(orderByParameterTitles.indexOf(s)))
						.collect(Collectors.toList());
			List<String> finalSortDirection;
			if (ObjectChecker.isEmptyOrNull(selectedSortDirections) && ObjectChecker.isNotEmptyOrNull(orderByDirections))
				finalSortDirection = selectedOrderBy.stream().map(s -> orderByDirections.get(orderByParameterTitles.indexOf(s)))
						.collect(Collectors.toList());
			else
				finalSortDirection = new ArrayList<>(selectedSortDirections == null ? new ArrayList<>() : selectedSortDirections);
			Set<String> uniqueOrderBy = new HashSet<>();
			List<String> orderBy = new ArrayList<>();
			if (columnsBeforeGroupFields)
				appendSortFields(orderByColumns, uniqueOrderBy, finalSortDirection, orderBy);
			appendGroupFields(finalSortDirection, orderBy);
			if (!columnsBeforeGroupFields)
				appendSortFields(orderByColumns, uniqueOrderBy, finalSortDirection, orderBy);
			if (ObjectChecker.isEmptyOrNull(orderBy))
				return "";
			return String.join(",", orderBy);
		}

		private void appendSortFields(List<String> orderByColumns, Set<String> uniqueOrderBy, List<String> finalSortDirection, List<String> orderBy)
		{
			if (ObjectChecker.isNotEmptyOrNull(orderByColumns))
			{
				for (int i = 0; i < orderByColumns.size(); i++)
				{
					String c = orderByColumns.get(i);
					if (ObjectChecker.isEmptyOrNull(c))
						continue;
					if (!uniqueOrderBy.add(c))
						continue;
					if (finalSortDirection.size() < i + 1)
						c += " " + ObjectChecker.toStringOrEmpty(CollectionsUtility.getFirst(finalSortDirection));
					else
						c += " " + finalSortDirection.get(i);
					orderBy.add(c);
				}
			}
		}

		private void appendGroupFields(List<String> finalSortDirection, List<String> orderBy)
		{
			if (ObjectChecker.isNotEmptyOrNull(groupsSort))
			{
				groupsSort.stream().map(s -> s + " " + ObjectChecker.toStringOrEmpty(CollectionsUtility.getFirst(finalSortDirection)))
						.forEach(orderBy::add);
			}
			if (ObjectChecker.areAllNotEmptyOrNull(sortsByGroupName, selectedGroupName))
			{
				List<String> selectedGroupSort = sortsByGroupName.get(selectedGroupName);
				if (ObjectChecker.isNotEmptyOrNull(selectedGroupSort))
					selectedGroupSort.stream().map(s -> s + " " + ObjectChecker.toStringOrEmpty(CollectionsUtility.getFirst(finalSortDirection)))
							.forEach(orderBy::add);
			}
		}
	}

	public static Object groupExpression(Object... parts)
	{
		return MultiKeyHash.of(parts);
	}

	public static OrderByData orderBy()
	{
		return new OrderByData();
	}

	public static long dateDiffInMonth(Date date1, Date date2)
	{
		if (date1 == null || date2 == null)
			return 0;
		LocalDate d1 = LocalDateUtils.dateToLocalDate(date1);
		LocalDate d2 = LocalDateUtils.dateToLocalDate(date2);
		Period period = Period.between(d1, d2.plusDays(1));
		return period.toTotalMonths() + (period.getDays() > 0 ? 1 : 0);
	}

	public static <K, V> Map<K, V> map(Object... objects)
	{
		return CollectionsUtility.map(objects);
	}

	public static RepRef repRef(String entityType, Object id, String code, String name1, String name2)
	{
		return new RepRef(entityType, id, code, name1, name2);
	}

	public static RepRef repRef(String entityType, Object id, String code, String name1, String name2, String orderBy)
	{
		return new RepRef(entityType, id, code, name1, name2, orderBy);
	}

	public static RepRef repRefOrderByCode(String entityType, Object id, String code, String name1, String name2)
	{
		return new RepRef(entityType, id, code, name1, name2);
	}

	public static RepRef repRefOrderById(String entityType, Object id, String code, String name1, String name2)
	{
		return new RepRef(entityType, id, code, name1, name2, CommonFieldIds.ID);
	}

	public static RepRef repRefOrderByName1(String entityType, Object id, String code, String name1, String name2)
	{
		return new RepRef(entityType, id, code, name1, name2, CommonFieldIds.NAME1);
	}

	public static RepRef repRefOrderByName2(String entityType, Object id, String code, String name1, String name2)
	{
		return new RepRef(entityType, id, code, name1, name2, CommonFieldIds.NAME2);
	}

	public static class RepRef implements Comparable<RepRef>, Serializable
	{
		public String entityType;
		public String id;
		public String code;
		public String name1;
		public String name2;
		public String orderBy;
		private String strValue;

		public RepRef()
		{
		}

		public RepRef(String entityType, Object id, String code, String name1, String name2)
		{
			this.entityType = entityType;
			this.id = ObjectChecker.toStringOrEmpty(convertIdIfNeeded(id));
			this.code = code;
			this.name1 = name1;
			this.name2 = name2;
			strValue = code + "@" + id + "@" + entityType;
			if (ObjectChecker.isNotEmptyOrNull(name1))
				strValue += "@" + name1;
			if (ObjectChecker.isNotEmptyOrNull(name2))
				strValue += "@" + name2;
		}

		public RepRef(String entityType, Object id, String code, String name1, String name2, String orderBy)
		{
			this.entityType = entityType;
			this.id = ObjectChecker.toStringOrEmpty(convertIdIfNeeded(id));
			this.code = code;
			this.name1 = name1;
			this.name2 = name2;
			this.orderBy = orderBy;
		}

		public String fetchOrderBy()
		{
			if (ObjectChecker.isEmptyOrNull(orderBy) || ObjectChecker.areEqual(orderBy, CommonFieldIds.CODE))
				return code;
			if (ObjectChecker.areEqual(orderBy, CommonFieldIds.ID))
				return id;
			if (ObjectChecker.areEqual(orderBy, CommonFieldIds.ENTITY_TYPE))
				return entityType;
			if (ObjectChecker.areEqual(orderBy, CommonFieldIds.NAME1))
				return name1;
			if (ObjectChecker.areEqual(orderBy, CommonFieldIds.NAME2))
				return name2;
			return code;
		}

		@Override
		public int compareTo(RepRef o)
		{
			if (o.fetchOrderBy() == null || fetchOrderBy() == null)
				return fetchOrderBy() == null ? 0 : 1;
			return fetchOrderBy() == null ? 1 : fetchOrderBy().compareTo(o.fetchOrderBy());
		}

		@Override
		public String toString()
		{
			return strValue;
		}

		@Override
		public boolean equals(Object o)
		{
			if (this == o)
				return true;
			if (!(o instanceof RepRef))
				return false;
			RepRef repRef = (RepRef) o;
			return Objects.equals(entityType, repRef.entityType) && Objects.equals(id, repRef.id) && Objects.equals(code, repRef.code)
					&& Objects.equals(name1, repRef.name1) && Objects.equals(name2, repRef.name2);
		}

		@Override
		public int hashCode()
		{
			return Objects.hash(entityType, id, code, name1, name2);
		}
	}

	public static SecurityConstraints security()
	{
		return new SecurityConstraints();
	}

	public static class SecurityConstraints
	{
		private String fieldEntityType;
		private String tableAlias;
		private List<String> capabilities = new ArrayList<>();

		public SecurityConstraints fieldEntityType(String fieldEntityType)
		{
			this.fieldEntityType = fieldEntityType;
			return this;
		}

		public SecurityConstraints tableAlias(String tableAlias)
		{
			this.tableAlias = tableAlias;
			return this;
		}

		public SecurityConstraints capabilities(String... capabilities)
		{
			this.capabilities.addAll(Arrays.asList(capabilities));
			return this;
		}

		public String toString()
		{
			return NaMaLayersConnector.getInstance().addSecurityConstraints(fieldEntityType, tableAlias, capabilities.toArray(new String[] {}));
		}
	}

	public static String addSecurityConstraints(String fieldEntityType, String tableAlias, String... capabilities)
	{
		return NaMaLayersConnector.getInstance().addSecurityConstraints(fieldEntityType, tableAlias, capabilities);
	}

	//zero if null
	public static BigDecimal zeroIfNull()
	{
		return BigDecimal.ZERO;
	}

	public static BigDecimal zeroIfNull(Object n)
	{
		return zeroIfNull(decimalFromObject(n));
	}

	public static BigDecimal zeroIfNull(BigDecimal n)
	{
		return ObjectChecker.toZeroIfNull(n);
	}

	public static Integer zeroIfNull(Integer n)
	{
		return ObjectChecker.toZeroIfNull(n);
	}

	public static Long zeroIfNull(Long n)
	{
		return ObjectChecker.toZeroIfNull(n);
	}

	//one if zero
	public static BigDecimal oneIfZero(Object n)
	{
		return oneIfZero(decimalFromObject(n));
	}

	public static BigDecimal decimalFromObject(Object n)
	{
		if (n == null)
			return BigDecimal.ZERO;
		if (n instanceof BigDecimal)
			return (BigDecimal) n;
		return zeroIfNull(ObjectChecker.tryParseDecimal(ObjectChecker.toStringOrEmpty(n)));
	}

	public static BigDecimal oneIfZero(BigDecimal n)
	{
		return ObjectChecker.toOneIfZero(n);
	}

	public static Integer oneIfZero(Integer n)
	{
		return ObjectChecker.toOneIfZero(n);
	}

	public static Long oneIfZero(Long n)
	{
		return ObjectChecker.toOneIfZero(n);
	}

	//nullIfZero
	public static BigDecimal nullIfZero(Object n)
	{
		return nullIfZero(decimalFromObject(n));
	}

	public static BigDecimal nullIfZero(BigDecimal n)
	{
		return ObjectChecker.isEmptyOrZero(n) ? null : n;
	}

	public static Integer nullIfZero(Integer n)
	{
		return ObjectChecker.isEmptyOrZero(n) ? null : n;
	}

	public static Long nullIfZero(Long n)
	{
		return ObjectChecker.isEmptyOrZero(n) ? null : n;
	}

	public static String shortenURL(String server, String signature, String url)
	{
		return ComplexRenderer.shortenURL(server, signature, url);
	}

	public static String zatcaHashedInvoice(Object entityType, Object id)
	{
		return NaMaLayersConnector.getInstance().zatcaHashedInvoice(entityType,id);
	}

	public static String genZatcaQrCodeFromEntity(Object entityType, Object idOrCode)
	{
		return NaMaLayersConnector.getInstance().genZatcaQrCodeFromEntity(entityType, idOrCode);
	}

	public static String encryptX(String input)
	{
		return CryptoUtils.encryptX(input);
	}

	public static String decryptX(String input)
	{
		return CryptoUtils.decryptX(input);
	}

	public static String encrypt1(String input)
	{
		return CryptoUtils.encrypt1(input);
	}

	public static String decrypt1(String input)
	{
		return CryptoUtils.decrypt1(input);
	}

	public static String encrypt2(String input)
	{
		return CryptoUtils.encrypt2(input);
	}

	public static String decrypt2(String input)
	{
		return CryptoUtils.decrypt2(input);
	}

	private static final String SAR_SVG = """
			<?xml version="1.0" encoding="UTF-8"?>
			<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1124.14 1256.39">
			  <defs>
			    <style>
			      .cls-1 {
			        fill: #231f20;
			      }
			    </style>
			  </defs>
			  <path class="cls-1" d="M699.62,1113.02h0c-20.06,44.48-33.32,92.75-38.4,143.37l424.51-90.24c20.06-44.47,33.31-92.75,38.4-143.37l-424.51,90.24Z"/>
			  <path class="cls-1" d="M1085.73,895.8c20.06-44.47,33.32-92.75,38.4-143.37l-330.68,70.33v-135.2l292.27-62.11c20.06-44.47,33.32-92.75,38.4-143.37l-330.68,70.27V66.13c-50.67,28.45-95.67,66.32-132.25,110.99v403.35l-132.25,28.11V0c-50.67,28.44-95.67,66.32-132.25,110.99v525.69l-295.91,62.88c-20.06,44.47-33.33,92.75-38.42,143.37l334.33-71.05v170.26l-358.3,76.14c-20.06,44.47-33.32,92.75-38.4,143.37l375.04-79.7c30.53-6.35,56.77-24.4,73.83-49.24l68.78-101.97v-.02c7.14-10.55,11.3-23.27,11.3-36.97v-149.98l132.25-28.11v270.4l424.53-90.28Z"/>
			</svg>""";
	private static final byte[] SAR_SVG_BYTES = SAR_SVG.getBytes(StandardCharsets.UTF_8);

	public static InputStream sar()
	{
		return new ByteArrayInputStream(SAR_SVG_BYTES);
	}

	public static MobileQrInfoCreator mobileQr()
	{
		return new MobileQrInfoCreator();
	}
}
