package com.namasoft.contracts.common.dtos;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOSearchResultSettings implements Serializable
{
	private static final long serialVersionUID = -5156687934605776388L;
	private DTOPageData pageData;
	private String sortByColumn;
	private List<String> columnsToGet;

	public DTOSearchResultSettings()
	{
		columnsToGet = new ArrayList<String>();
	}

	public DTOSearchResultSettings(DTOPageData pageData, String sortByColumn)
	{
		this();
		this.pageData = pageData;
		this.sortByColumn = sortByColumn;
	}

	public DTOPageData getPageData()
	{
		return pageData;
	}

	public void setPageData(DTOPageData pageData)
	{
		this.pageData = pageData;
	}

	public String getSortByColumn()
	{
		return sortByColumn;
	}

	public void setSortByColumn(String sortByColumn)
	{
		this.sortByColumn = sortByColumn;
	}

	public List<String> getColumnsToGet()
	{
		return columnsToGet;
	}

	public void setColumnsToGet(List<String> columnsToGet)
	{
		this.columnsToGet = columnsToGet;
	}
}
