package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.criteria.DTOCriteriaBuilder;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.ObjectChecker;

public class AGGridReferenceFilterModel extends AGGridISimpleFilterModel
{
	private EntityReferenceData ref;

	public AGGridReferenceFilterModel()
	{
	}

	@Override
	public void appendExpression(DTOCriteriaBuilder.DTOExpressionBuilder expressionBuilder, String fieldId, String fieldType)
	{
		String suffix = "";
		String valueToCheckFor = ref == null ? null : ref.getId();
		if (ObjectChecker.areEqual(fieldType, FieldType.Genericreference))
		{
			if (ref != null && ObjectChecker.isNotEmptyOrNull(ref.getEntityType()) && ObjectChecker.isEmptyOrNull(ref.getId()))
			{
				suffix = ".entityType";
				valueToCheckFor = ref.getEntityType();
			}
			else
			{
				suffix = ".id";
			}
		}
		DTOCriteriaBuilder.DTOExpressionBuilder exp = expressionBuilder.and().field(fieldId + suffix);
		switch (getType())
		{
		case blank -> exp.isNull();
		case notBlank -> exp.isNotNull();
		case equals -> exp.equal(valueToCheckFor);
		case notEqual -> exp.notEqual(valueToCheckFor);
		}
	}

	public EntityReferenceData getRef()
	{
		return ref;
	}

	public void setRef(EntityReferenceData ref)
	{
		this.ref = ref;
	}
}
