package com.namasoft.contracts.common.dtos.requests;

import java.util.Date;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.flatobjects.EntityReferenceData;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CalcFiscalPeriodAndYearRequest extends ServiceRequest
{
	private EntityReferenceData legalEntity;
	private Date date;

	public CalcFiscalPeriodAndYearRequest(EntityReferenceData legalEntity, Date date)
	{
		this();
		this.legalEntity = legalEntity;
		this.date = date;
	}

	public CalcFiscalPeriodAndYearRequest()
	{
		super();
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public Date getDate()
	{
		return date;
	}

	public void setDate(Date date)
	{
		this.date = date;
	}

}
