package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.util.Date;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class FindByIDRequest extends FindRequest implements HasDoNotRunSqlFieldsInFactories<FindByIDRequest>
{
	private static final long serialVersionUID = -7861036124974951702L;
	private String id;
	private Integer version;
	private Boolean fromAction = false;
	private Date versionDate;
	private String revertBeforeOrAfter;

	protected FindByIDRequest()
	{
		super();
	}

	public FindByIDRequest(String entityType, String id, Boolean findDraft, Integer version)
	{
		super(findDraft, entityType);
		setId(id);
		setVersion(version);
	}

	public FindByIDRequest(String entityType, String id)
	{
		this(entityType, id, false, null);
	}

	public FindByIDRequest(String entityType, String id, Date versionDate, String revertBeforeOrAfter)
	{
		super(false, entityType);
		setId(id);
		setVersionDate(versionDate);
		setRevertBeforeOrAfter(revertBeforeOrAfter);
	}

	public FindByIDRequest(EntityReferenceData ref)
	{
		this(ref.getEntityType(), ref.getId());
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public Integer getVersion()
	{
		return version;
	}

	public void setVersion(Integer version)
	{
		this.version = version;
	}

	public Boolean getFromAction()
	{
		return ObjectChecker.isTrue(fromAction);
	}

	public void setFromAction(Boolean fromAction)
	{
		this.fromAction = fromAction;
	}

	@Override
	public Boolean fetchDoNotRunSqlFieldsInFactories()
	{
		return getFromAction();
	}

	@Override
	public void updateDoNotRunSqlFieldsInFactories(Boolean doNotRunSqlFieldsInFactories)
	{
		setFromAction(doNotRunSqlFieldsInFactories);
	}

	public Date getVersionDate()
	{
		return versionDate;
	}

	public void setVersionDate(Date versionDate)
	{
		this.versionDate = versionDate;
	}

	public String getRevertBeforeOrAfter()
	{
		return revertBeforeOrAfter;
	}

	public void setRevertBeforeOrAfter(String revertBeforeOrAfter)
	{
		this.revertBeforeOrAfter = revertBeforeOrAfter;
	}
}
