package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.constants.*;
import com.namasoft.common.criteria.DTOFilledQuestionField;
import jakarta.xml.bind.annotation.*;

import java.util.List;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class RunReportRequest extends ServiceRequest implements ReportBasicParamters
{
	private String reportId;
	private String mobileReportURLPrefix;
	private String tempPrintId;
	private OutputFormat format;
	private List<DTOFilledQuestionField> parameters;
	private PrintingOption printingOption;
	private String monitorId;
	private Boolean runAsynchronous;

	public RunReportRequest(String reportId)
	{
		super();
		setReportId(reportId);
	}

	public RunReportRequest()
	{
		super();
	}

	public String getReportId()
	{
		return reportId;
	}

	public void setReportId(String reportId)
	{
		this.reportId = reportId;
	}

	@Override
	public String getTempPrintId()
	{
		return tempPrintId;
	}

	public void setTempPrintId(String tempPrintId)
	{
		this.tempPrintId = tempPrintId;
	}

	@Override
	public OutputFormat getFormat()
	{
		return format;
	}

	public void setFormat(OutputFormat format)
	{
		this.format = format;
	}

	public List<DTOFilledQuestionField> getParameters()
	{
		return parameters;
	}

	public void setParameters(List<DTOFilledQuestionField> parameters)
	{
		this.parameters = parameters;
	}

	@Override
	public PrintingOption getPrintingOption()
	{
		return printingOption;
	}

	@Override
	public String entityType()
	{
		return null;
	}

	@Override
	public String entityId()
	{
		return null;
	}

	public void setPrintingOption(PrintingOption printingOption)
	{
		this.printingOption = printingOption;
	}

	public String getMonitorId()
	{
		return monitorId;
	}

	public void setMonitorId(String monitorId)
	{
		this.monitorId = monitorId;
	}

	@Override
	public List<DTOFilledQuestionField> fetchParameters()
	{
		return getParameters();
	}

	public String getMobileReportURLPrefix()
	{
		return mobileReportURLPrefix;
	}

	public void setMobileReportURLPrefix(String mobileReportURLPrefix)
	{
		this.mobileReportURLPrefix = mobileReportURLPrefix;
	}

	public Boolean getRunAsynchronous()
	{
		return runAsynchronous;
	}

	public void setRunAsynchronous(Boolean runAsynchronous)
	{
		this.runAsynchronous = runAsynchronous;
	}
}
