package com.namasoft.contracts.common.dtos.results;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DeleteResult extends ServiceResponse implements Serializable
{
	private static final long serialVersionUID = 2404194615129951868L;
	private Boolean pendingApproval;

	public DeleteResult()
	{
		super();
	}

	public DeleteResult(ResultDTO result)
	{
		super(result);
	}

	public Boolean getPendingApproval()
	{
		return pendingApproval;
	}

	public void setPendingApproval(Boolean pendingApproval)
	{
		this.pendingApproval = pendingApproval;
	}
}
