package com.namasoft.contracts.common.services;

import com.namasoft.common.ServiceResponse;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.PagedDTOTabularResult;
import com.namasoft.contracts.common.dtos.requests.*;
import com.namasoft.contracts.common.dtos.results.*;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.contracts.common.services.base.EntityService;
import com.namasoft.infra.contractsbase.common.approval.DTOApprovalCase;

public class BaseEntityServiceProxy<DTO, RefDTO> implements EntityService<DTO, RefDTO>
{
	private final String entityType;
	private UnifiedEntityWS handler;

	public BaseEntityServiceProxy(String entityType)
	{
		this.entityType = entityType;
	}

	public BaseEntityServiceProxy(String entityType, UnifiedEntityWS handler)
	{
		this.entityType = entityType;
		this.handler = handler;
	}

	private void ensureEntityType(EntityServiceRequest request)
	{
		request.setEntityType(getServiceEntityType());
	}

	private void ensureEntityType(GetApprovalRequest request)
	{
		request.setEntityType(getServiceEntityType());
	}

	private void ensureEntityType(SendRequest<DTOApproveFromURL> request)
	{
		if (request.getData() == null)
			request.setData(new DTOApproveFromURL());
		request.getData().setRecordType(getServiceEntityType());
	}

	@Override
	public CreateNewResult<DTO> createNew(CreateNewRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (CreateNewResult<DTO>) handler.createNew(request);
	}

	@Override
	public CreateNewResult<DTO> duplicate(ByIdRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (CreateNewResult<DTO>) handler.duplicate(request);
	}

	@Override
	public SaveDraftResult<DTO> saveDraft(SaveDraftRequest<DTO> request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (SaveDraftResult<DTO>) handler.saveDraft((SaveDraftRequest<BaseEntityDTO>) request);
	}

	@Override
	public RequestCommitResult<DTO> saveAndCommit(SaveDraftRequest<DTO> request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (RequestCommitResult<DTO>) handler.saveAndCommit((SaveDraftRequest<BaseEntityDTO>) request);
	}

	@Override
	public GetResult<DTO> findByID(FindByIDRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (GetResult<DTO>) handler.findByID(request);
	}

	@Override
	public GetResult<DTO> findByBusinessCode(FindByBusinessCodeRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (GetResult<DTO>) handler.findByBusinessCode(request);
	}

	@Override
	public ListResult<DTO> listPageMatching(ListPageMatchingRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (ListResult<DTO>) handler.listPageMatching(request);
	}

	@Override
	public ListResult<FlatObject> listPageMatchingFlat(ListPageMatchingRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.listPageMatchingFlat(request);
	}

	@Override
	public ListResult<RefDTO> listPageMatchingRef(ListPageMatchingRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (ListResult<RefDTO>) handler.listPageMatchingRef(request);
	}

	@Override
	public RequestCommitResult<DTO> requestCommit(RequestCommitRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (RequestCommitResult<DTO>) handler.requestCommit(request);
	}

	@Override
	public GetResult<RefDTO> findRefByBusinessCode(ByCodeRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (GetResult<RefDTO>) handler.findRefByBusinessCode(request);
	}

	@Override
	public GetResult<RefDTO> findRefById(ByIdRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (GetResult<RefDTO>) handler.findRefById(request);
	}

	@Override
	public DeleteResult delete(EntityOperationRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.delete(request);
	}

	@Override
	public GetResult<Long> count(EntityServiceRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.count(request);
	}

	@Override
	public PagedDTOTabularResult tabularListPage(TabularRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.tabularListPage(request);
	}

	@Override
	public GetResult<DTO> navigate(NavigationRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return (GetResult<DTO>) handler.navigate(request);
	}

	@Override
	public GetResult<Long> getCurrentRecordOrderInList(NavigationRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.getCurrentRecordOrderInList(request);
	}

	@Override
	public PagedDTOTabularResult search(SearchRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.search(request);
	}

	@Override
	public String getServiceEntityType() throws NaMaServiceExcepption
	{
		return entityType;
	}

	@Override
	public ListEntityResult list(ListRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.list(request);
	}

	@Override
	public FlatListEntityResult listFlat(ListRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.listFlat(request);
	}

	@Override
	public ListTimelineResult listForTimeline(ListRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.listForTimeline(request);
	}

	@Override
	public ListResult<DTOApprovalCase> getApprovalHistory(GetApprovalRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.getApprovalHistory(request);
	}

	@Override
	public GetResult<DTOApprovalCase> approve(ApproveRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.approve(request);
	}

	@Override
	public GetResult<DTOApprovalCase> approveFromURL(SendRequest<DTOApproveFromURL> request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.approveFromURL(request);
	}

	@Override
	public GetResult<Boolean> shouldShowCommentBoxForApprovalURL(SendRequest<DTOApproveFromURL> request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.shouldShowCommentBoxForApprovalURL(request);
	}

	@Override
	public GetResult<DTOApprovalCase> getCurrentApprovalCase(GetApprovalRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.getCurrentApprovalCase(request);
	}

	@Override
	public ServiceResponse reReplicate(EntityOperationRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.reReplicate(request);
	}

	@Override
	public ServiceResponse reCommit(EntityOperationRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.reCommit(request);
	}

	@Override
	public ServiceResponse markRevised(MarkRevisedRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.markRevised(request);
	}

	@Override
	public ServiceResponse restoreDeletedRecord(FindByIDRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.restoreDeletedRecord(request);
	}

	@Override
	public ServiceResponse changeCapability(ChangeCapabilitiesRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.changeCapability(request);
	}

	@Override
	public GetResult<Long> countRecordsMatching(ListPageMatchingRequest request) throws NaMaServiceExcepption
	{
		ensureEntityType(request);
		return handler.countRecordsMatching(request);
	}

	public UnifiedEntityWS getHandler()
	{
		return handler;
	}

	public void setHandler(UnifiedEntityWS handler)
	{
		this.handler = handler;
	}
}
