package com.namasoft.infra.contractsbase.common.approval;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOSpecialResponsible extends MasterFileDTO implements Serializable
{
	private DTOGenericDimensions sourceDimensions;
	private DTOResponsibleDimSource analysisSource;
	private DTOResponsibleDimSource branchSource;
	private DTOResponsibleDimSource departmentSource;
	private DTOResponsibleDimSource sectorSource;
	private EntityReferenceData employee;
	private EntityReferenceData employeeGroup;
	private EntityReferenceData position;
	private EntityReferenceData responsibility;
	public DTOGenericDimensions getSourceDimensions()
	{
		return sourceDimensions;
	}

	public DTOResponsibleDimSource getAnalysisSource()
	{
		return analysisSource;
	}

	public DTOResponsibleDimSource getBranchSource()
	{
		return branchSource;
	}

	public DTOResponsibleDimSource getDepartmentSource()
	{
		return departmentSource;
	}

	public DTOResponsibleDimSource getSectorSource()
	{
		return sectorSource;
	}

	public EntityReferenceData getEmployee()
	{
		return employee;
	}

	public EntityReferenceData getEmployeeGroup()
	{
		return employeeGroup;
	}

	public EntityReferenceData getPosition()
	{
		return position;
	}

	public EntityReferenceData getResponsibility()
	{
		return responsibility;
	}

	public void setAnalysisSource(DTOResponsibleDimSource analysisSource)
	{
		this.analysisSource = analysisSource;
	}

	public void setBranchSource(DTOResponsibleDimSource branchSource)
	{
		this.branchSource = branchSource;
	}

	public void setDepartmentSource(DTOResponsibleDimSource departmentSource)
	{
		this.departmentSource = departmentSource;
	}

	public void setEmployee(EntityReferenceData employee)
	{
		this.employee = employee;
	}

	public void setEmployeeGroup(EntityReferenceData employeeGroup)
	{
		this.employeeGroup = employeeGroup;
	}

	public void setPosition(EntityReferenceData position)
	{
		this.position = position;
	}

	public void setResponsibility(EntityReferenceData responsibility)
	{
		this.responsibility = responsibility;
	}

	public void setSectorSource(DTOResponsibleDimSource sectorSource)
	{
		this.sectorSource = sectorSource;
	}

	public void setSourceDimensions(DTOGenericDimensions sourceDimensions)
	{
		this.sourceDimensions = sourceDimensions;
	}

}
