package com.namasoft.modules.commonbasic.contracts.details;

import com.namasoft.common.constants.BSCEntities;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOMenuTarget;
import com.namasoft.modules.commonbasic.enums.MenuTargetType;
import jakarta.xml.bind.annotation.*;

import java.io.Serializable;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOUserFavouritesLine extends GeneratedDTOUserFavouritesLine implements Serializable
{
	public DTOMenuItem toMenuItem()
	{
		DTOMenuItem item = new DTOMenuItem();
		item.setTarget(new DTOMenuTarget());
		item.getTarget().setTargetRecord(getTargetFile());
		item.getTarget().setType(MenuTargetType.Record.name());
		item.getTarget().setCriteria(getCriteria());
		item.setName1(getArabic());
		item.setName2(getEnglish());
		item.setGroupCode(getParentGroupCode());
		item.setCode(getParentGroupCode() + "-" + ObjectChecker
				.getFirstNotEmptyObj(getTargetFile().getCode(), getTargetFile().getAltCode(), getTargetFile().getEntityType()));
		item.getTarget().setViewName(ObjectChecker.toStringOrEmpty(getViewName()));
		if (ObjectChecker.areAllEmptyOrNull(getTargetFile().getCode(), getTargetFile().getId(), getTargetFile().getAltCode()))
		{
			item.getTarget().setTargetEntity(getTargetFile().getEntityType());
			item.getTarget().setType(MenuTargetType.NewRecord.name());
		}
		else if (ObjectChecker.areEqual(getTargetFile().getEntityType(), BSCEntities.DashBoard))
		{
			item.getTarget().setType(MenuTargetType.Dashboard.name());
		}
		else if (ObjectChecker.areEqual(getTargetFile().getEntityType(), BSCEntities.ReportDefinition))
		{
			item.getTarget().setType(MenuTargetType.Report.name());
		}
		else if (ObjectChecker.areEqual(getTargetFile().getEntityType(), BSCEntities.ReportGroup))
		{
			item.getTarget().setType(MenuTargetType.ReportsGroup.name());
		}
		else if (ObjectChecker.areEqual(getTargetFile().getEntityType(), BSCEntities.DashBoardGroup))
		{
			item.getTarget().setType(MenuTargetType.DashboardsGroup.name());
		}
		if (ObjectChecker.areEqual(getElementType(), "CreateNew"))
		{
			item.getTarget().setType(MenuTargetType.NewRecord.name());
		}
		else if (ObjectChecker.areEqual(getElementType(), "ListView"))
		{
			item.getTarget().setType(MenuTargetType.EntityList.name());
		}
		return item;
	}
}
