package com.namasoft.modules.commonbasic.contracts.valueobjects;

import java.io.Serializable;
import java.math.BigDecimal;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOMoneyEffectDetails extends GeneratedDTOMoneyEffectDetails implements Serializable
{
	public DTOMoneyEffectDetails updateNulls()
	{
		setAfterValue(NaMaMath.zeroIfNull(getAfterValue()));
		setValue(NaMaMath.zeroIfNull(getValue()));
		setPercentage(NaMaMath.zeroIfNull(getPercentage()));
		setMaxNormalPercent(NaMaMath.zeroIfNull(getMaxNormalPercent()));
		return this;
	}

	public DTOMoneyEffectDetails cloneValue()
	{
		DTOMoneyEffectDetails effect = new DTOMoneyEffectDetails();
		effect.setAfterValue(getAfterValue());
		effect.setPercentage(getPercentage());
		effect.setValue(getValue());
		effect.setMaxNormalPercent(getMaxNormalPercent());
		return effect;
	}

	public void resetMoney()
	{
		setValue(BigDecimal.ZERO);
		setPercentage(BigDecimal.ZERO);
		setMaxNormalPercent(BigDecimal.ZERO);
		setAfterValue(BigDecimal.ZERO);
	}
	
	public void updatePercent(BigDecimal percentage,BigDecimal normalDiscount)
	{
		setPercentage(percentage);
		setMaxNormalPercent(NaMaMath.zeroIfNull(normalDiscount));
	}

	public void updateTaxValueFromPercentages(BigDecimal price, Integer scale)
	{
		setValue(NaMaMath.calcPercentageValue(ObjectChecker.toZeroIfNull(price), getMaxNormalPercent(), scale));
	}

	public void updateTaxPercentage(BigDecimal price, Integer percentageScale)
	{
		setMaxNormalPercent(NaMaMath.calcPercentage(ObjectChecker.toZeroIfNull(price), getValue(), percentageScale));
	}
}
