package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTOLocalEntity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOLegalEntityLicense extends DTOLocalEntity implements Serializable
{
	private BigDecimal paymentValue;
	private Date creationDate;
	private Date endEffectiveDate;
	private Date paymentDate;
	private Date startEffectiveDate;
	private EntityReferenceData legalEntity;
	private Integer maxNumOfUsers;
	private Long maxNumOfNewRecord;
	private String allowedEntities;
	private String allowedFeatures;
	private String info;
	private String preventedEntities;
	private String preventedFeatures;
	private String userPreventedEntities;
	private String userPreventedFeatures;
	public BigDecimal getPaymentValue()
	{
		return paymentValue;
	}

	public Date getCreationDate()
	{
		return creationDate;
	}

	public Date getEndEffectiveDate()
	{
		return endEffectiveDate;
	}

	public Date getPaymentDate()
	{
		return paymentDate;
	}

	public Date getStartEffectiveDate()
	{
		return startEffectiveDate;
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public Integer getMaxNumOfUsers()
	{
		return maxNumOfUsers;
	}

	public Long getMaxNumOfNewRecord()
	{
		return maxNumOfNewRecord;
	}

	public String getAllowedEntities()
	{
		return allowedEntities;
	}

	public String getAllowedFeatures()
	{
		return allowedFeatures;
	}

	public String getInfo()
	{
		return info;
	}

	public String getPreventedEntities()
	{
		return preventedEntities;
	}

	public String getPreventedFeatures()
	{
		return preventedFeatures;
	}

	public String getUserPreventedEntities()
	{
		return userPreventedEntities;
	}

	public String getUserPreventedFeatures()
	{
		return userPreventedFeatures;
	}

	public void setAllowedEntities(String allowedEntities)
	{
		this.allowedEntities = allowedEntities;
	}

	public void setAllowedFeatures(String allowedFeatures)
	{
		this.allowedFeatures = allowedFeatures;
	}

	public void setCreationDate(Date creationDate)
	{
		this.creationDate = creationDate;
	}

	public void setEndEffectiveDate(Date endEffectiveDate)
	{
		this.endEffectiveDate = endEffectiveDate;
	}

	public void setInfo(String info)
	{
		this.info = info;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public void setMaxNumOfNewRecord(Long maxNumOfNewRecord)
	{
		this.maxNumOfNewRecord = maxNumOfNewRecord;
	}

	public void setMaxNumOfUsers(Integer maxNumOfUsers)
	{
		this.maxNumOfUsers = maxNumOfUsers;
	}

	public void setPaymentDate(Date paymentDate)
	{
		this.paymentDate = paymentDate;
	}

	public void setPaymentValue(BigDecimal paymentValue)
	{
		this.paymentValue = paymentValue;
	}

	public void setPreventedEntities(String preventedEntities)
	{
		this.preventedEntities = preventedEntities;
	}

	public void setPreventedFeatures(String preventedFeatures)
	{
		this.preventedFeatures = preventedFeatures;
	}

	public void setStartEffectiveDate(Date startEffectiveDate)
	{
		this.startEffectiveDate = startEffectiveDate;
	}

	public void setUserPreventedEntities(String userPreventedEntities)
	{
		this.userPreventedEntities = userPreventedEntities;
	}

	public void setUserPreventedFeatures(String userPreventedFeatures)
	{
		this.userPreventedFeatures = userPreventedFeatures;
	}

}
