package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import com.namasoft.contracts.common.dtos.DTOTimePeriod;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOUserSettings implements Serializable
{
	private Boolean allowEditFrozenCostAccounts;
	private Boolean allowPDFPrintOnlyForForms;
	private Boolean allowPDFPrintOnlyForReports;
	private Boolean allowPreventedRecordsInInsert;
	private Boolean allowPreventedRecordsInUpdate;
	private Boolean alwaysPrint1InBarcode;
	private Boolean autoFetchUserShift;
	private Boolean autoLogoutWithMaxSessions;
	private Boolean barCodeOn;
	private Boolean canViewMenuItems;
	private Boolean defaultUserForEmployee;
	private Boolean directPrint;
	private Boolean doNotCreatingTroubleTicketReq;
	private Boolean doNotDisplayCriticalErrors;
	private Boolean doNotDisplaySystemHelpMsgs;
	private Boolean doNotUseLDAPForLogin;
	private Boolean dontUseAsFirstAuthor;
	private Boolean excludeFrom2FA;
	private Boolean hijriDate;
	private Boolean loginFromAppsOnly;
	private Boolean passwordMustBeChanged;
	private Boolean posUser;
	private Boolean prevUserToRunSameRepMultipleTimes;
	private Boolean preventEssLogin;
	private Boolean preventLogin;
	private Boolean preventModifyContext;
	private Boolean preventPublicLogin;
	private Boolean printDocumentsOnSave;
	private Boolean treatAsAdmin;
	private Boolean viewSystemReports;
	private DTOFontInfo fontInfo;
	private DTOGenericDimensions loginContext;
	private DTOLargeData attachment;
	private DTOLargeData backgroundImage;
	private DTOTimePeriod notificationCheckPeriod;
	private Date resetPasswordRequestedOn;
	private EntityReferenceData dashBoard;
	private EntityReferenceData mobileAppDashboard;
	private EntityReferenceData mobileAppMenuDefinition;
	private EntityReferenceData posSecurityProfile;
	private EntityReferenceData relatedEntity;
	private EntityReferenceData timedQuery;
	private EntityReferenceData usersCounter;
	private Integer allowSavesHOOnlineCount;
	private Integer autoLogoutTime;
	private Integer htmlRepZoom;
	private Integer maxExportCount;
	private Integer maxLoginSessions;
	private Integer maxNumberToRunReport;
	private Integer maxRecordsPerPageForListViews;
	private Integer notificationsCount;
	private List<DTOCustomSecurityLine> customLines = new ArrayList<DTOCustomSecurityLine>();
	private List<DTOExtraSecurityFilters> extraFilters = new ArrayList<DTOExtraSecurityFilters>();
	private List<DTOListViewSecurityLine> listViewSecurityLines = new ArrayList<DTOListViewSecurityLine>();
	private List<DTOLoginDimensionLine> loginDimensions = new ArrayList<DTOLoginDimensionLine>();
	private List<DTOPageSecurity> pageSecurity = new ArrayList<DTOPageSecurity>();
	private List<DTOSecurityFieldAuthority> disabledFields = new ArrayList<DTOSecurityFieldAuthority>();
	private List<DTOTreatAsUsersInFirstAuthorLine> treatAsUsersInFirstAuthor = new ArrayList<DTOTreatAsUsersInFirstAuthorLine>();
	private List<DTOUserStandardSecurityLine> standardLines = new ArrayList<DTOUserStandardSecurityLine>();
	private String allowAccessToAI;
	private String defaultLayoutName;
	private String defaultPageSize;
	private String emailPassword;
	private String emailUsedWithSendAsEmailWindow;
	private String fcmDeviceTokens;
	private String mobile;
	private String notificationContent;
	private String preventedLoginMessage;
	private String resetPasswordToken;
	private String userLevel;
	private String viewingFormat;
	public Boolean getAllowEditFrozenCostAccounts()
	{
		return allowEditFrozenCostAccounts;
	}

	public Boolean getAllowPDFPrintOnlyForForms()
	{
		return allowPDFPrintOnlyForForms;
	}

	public Boolean getAllowPDFPrintOnlyForReports()
	{
		return allowPDFPrintOnlyForReports;
	}

	public Boolean getAllowPreventedRecordsInInsert()
	{
		return allowPreventedRecordsInInsert;
	}

	public Boolean getAllowPreventedRecordsInUpdate()
	{
		return allowPreventedRecordsInUpdate;
	}

	public Boolean getAlwaysPrint1InBarcode()
	{
		return alwaysPrint1InBarcode;
	}

	public Boolean getAutoFetchUserShift()
	{
		return autoFetchUserShift;
	}

	public Boolean getAutoLogoutWithMaxSessions()
	{
		return autoLogoutWithMaxSessions;
	}

	public Boolean getBarCodeOn()
	{
		return barCodeOn;
	}

	public Boolean getCanViewMenuItems()
	{
		return canViewMenuItems;
	}

	public Boolean getDefaultUserForEmployee()
	{
		return defaultUserForEmployee;
	}

	public Boolean getDirectPrint()
	{
		return directPrint;
	}

	public Boolean getDoNotCreatingTroubleTicketReq()
	{
		return doNotCreatingTroubleTicketReq;
	}

	public Boolean getDoNotDisplayCriticalErrors()
	{
		return doNotDisplayCriticalErrors;
	}

	public Boolean getDoNotDisplaySystemHelpMsgs()
	{
		return doNotDisplaySystemHelpMsgs;
	}

	public Boolean getDoNotUseLDAPForLogin()
	{
		return doNotUseLDAPForLogin;
	}

	public Boolean getDontUseAsFirstAuthor()
	{
		return dontUseAsFirstAuthor;
	}

	public Boolean getExcludeFrom2FA()
	{
		return excludeFrom2FA;
	}

	public Boolean getHijriDate()
	{
		return hijriDate;
	}

	public Boolean getLoginFromAppsOnly()
	{
		return loginFromAppsOnly;
	}

	public Boolean getPasswordMustBeChanged()
	{
		return passwordMustBeChanged;
	}

	public Boolean getPosUser()
	{
		return posUser;
	}

	public Boolean getPrevUserToRunSameRepMultipleTimes()
	{
		return prevUserToRunSameRepMultipleTimes;
	}

	public Boolean getPreventEssLogin()
	{
		return preventEssLogin;
	}

	public Boolean getPreventLogin()
	{
		return preventLogin;
	}

	public Boolean getPreventModifyContext()
	{
		return preventModifyContext;
	}

	public Boolean getPreventPublicLogin()
	{
		return preventPublicLogin;
	}

	public Boolean getPrintDocumentsOnSave()
	{
		return printDocumentsOnSave;
	}

	public Boolean getTreatAsAdmin()
	{
		return treatAsAdmin;
	}

	public Boolean getViewSystemReports()
	{
		return viewSystemReports;
	}

	public DTOFontInfo getFontInfo()
	{
		return fontInfo;
	}

	public DTOGenericDimensions getLoginContext()
	{
		return loginContext;
	}

	public DTOLargeData getAttachment()
	{
		return attachment;
	}

	public DTOLargeData getBackgroundImage()
	{
		return backgroundImage;
	}

	public DTOTimePeriod getNotificationCheckPeriod()
	{
		return notificationCheckPeriod;
	}

	public Date getResetPasswordRequestedOn()
	{
		return resetPasswordRequestedOn;
	}

	public EntityReferenceData getDashBoard()
	{
		return dashBoard;
	}

	public EntityReferenceData getMobileAppDashboard()
	{
		return mobileAppDashboard;
	}

	public EntityReferenceData getMobileAppMenuDefinition()
	{
		return mobileAppMenuDefinition;
	}

	public EntityReferenceData getPosSecurityProfile()
	{
		return posSecurityProfile;
	}

	public EntityReferenceData getRelatedEntity()
	{
		return relatedEntity;
	}

	public EntityReferenceData getTimedQuery()
	{
		return timedQuery;
	}

	public EntityReferenceData getUsersCounter()
	{
		return usersCounter;
	}

	public Integer getAllowSavesHOOnlineCount()
	{
		return allowSavesHOOnlineCount;
	}

	public Integer getAutoLogoutTime()
	{
		return autoLogoutTime;
	}

	public Integer getHtmlRepZoom()
	{
		return htmlRepZoom;
	}

	public Integer getMaxExportCount()
	{
		return maxExportCount;
	}

	public Integer getMaxLoginSessions()
	{
		return maxLoginSessions;
	}

	public Integer getMaxNumberToRunReport()
	{
		return maxNumberToRunReport;
	}

	public Integer getMaxRecordsPerPageForListViews()
	{
		return maxRecordsPerPageForListViews;
	}

	public Integer getNotificationsCount()
	{
		return notificationsCount;
	}

	public List<DTOCustomSecurityLine> getCustomLines()
	{
		return customLines;
	}

	public List<DTOExtraSecurityFilters> getExtraFilters()
	{
		return extraFilters;
	}

	public List<DTOListViewSecurityLine> getListViewSecurityLines()
	{
		return listViewSecurityLines;
	}

	public List<DTOLoginDimensionLine> getLoginDimensions()
	{
		return loginDimensions;
	}

	public List<DTOPageSecurity> getPageSecurity()
	{
		return pageSecurity;
	}

	public List<DTOSecurityFieldAuthority> getDisabledFields()
	{
		return disabledFields;
	}

	public List<DTOTreatAsUsersInFirstAuthorLine> getTreatAsUsersInFirstAuthor()
	{
		return treatAsUsersInFirstAuthor;
	}

	public List<DTOUserStandardSecurityLine> getStandardLines()
	{
		return standardLines;
	}

	public String getAllowAccessToAI()
	{
		return allowAccessToAI;
	}

	public String getDefaultLayoutName()
	{
		return defaultLayoutName;
	}

	public String getDefaultPageSize()
	{
		return defaultPageSize;
	}

	public String getEmailPassword()
	{
		return emailPassword;
	}

	public String getEmailUsedWithSendAsEmailWindow()
	{
		return emailUsedWithSendAsEmailWindow;
	}

	public String getFcmDeviceTokens()
	{
		return fcmDeviceTokens;
	}

	public String getMobile()
	{
		return mobile;
	}

	public String getNotificationContent()
	{
		return notificationContent;
	}

	public String getPreventedLoginMessage()
	{
		return preventedLoginMessage;
	}

	public String getResetPasswordToken()
	{
		return resetPasswordToken;
	}

	public String getUserLevel()
	{
		return userLevel;
	}

	public String getViewingFormat()
	{
		return viewingFormat;
	}

	public void setAllowAccessToAI(String allowAccessToAI)
	{
		this.allowAccessToAI = allowAccessToAI;
	}

	public void setAllowEditFrozenCostAccounts(Boolean allowEditFrozenCostAccounts)
	{
		this.allowEditFrozenCostAccounts = allowEditFrozenCostAccounts;
	}

	public void setAllowPDFPrintOnlyForForms(Boolean allowPDFPrintOnlyForForms)
	{
		this.allowPDFPrintOnlyForForms = allowPDFPrintOnlyForForms;
	}

	public void setAllowPDFPrintOnlyForReports(Boolean allowPDFPrintOnlyForReports)
	{
		this.allowPDFPrintOnlyForReports = allowPDFPrintOnlyForReports;
	}

	public void setAllowPreventedRecordsInInsert(Boolean allowPreventedRecordsInInsert)
	{
		this.allowPreventedRecordsInInsert = allowPreventedRecordsInInsert;
	}

	public void setAllowPreventedRecordsInUpdate(Boolean allowPreventedRecordsInUpdate)
	{
		this.allowPreventedRecordsInUpdate = allowPreventedRecordsInUpdate;
	}

	public void setAllowSavesHOOnlineCount(Integer allowSavesHOOnlineCount)
	{
		this.allowSavesHOOnlineCount = allowSavesHOOnlineCount;
	}

	public void setAlwaysPrint1InBarcode(Boolean alwaysPrint1InBarcode)
	{
		this.alwaysPrint1InBarcode = alwaysPrint1InBarcode;
	}

	public void setAttachment(DTOLargeData attachment)
	{
		this.attachment = attachment;
	}

	public void setAutoFetchUserShift(Boolean autoFetchUserShift)
	{
		this.autoFetchUserShift = autoFetchUserShift;
	}

	public void setAutoLogoutTime(Integer autoLogoutTime)
	{
		this.autoLogoutTime = autoLogoutTime;
	}

	public void setAutoLogoutWithMaxSessions(Boolean autoLogoutWithMaxSessions)
	{
		this.autoLogoutWithMaxSessions = autoLogoutWithMaxSessions;
	}

	public void setBackgroundImage(DTOLargeData backgroundImage)
	{
		this.backgroundImage = backgroundImage;
	}

	public void setBarCodeOn(Boolean barCodeOn)
	{
		this.barCodeOn = barCodeOn;
	}

	public void setCanViewMenuItems(Boolean canViewMenuItems)
	{
		this.canViewMenuItems = canViewMenuItems;
	}

	public void setCustomLines(List<DTOCustomSecurityLine> customLines)
	{
		this.customLines = customLines;
	}

	public void setDashBoard(EntityReferenceData dashBoard)
	{
		this.dashBoard = dashBoard;
	}

	public void setDefaultLayoutName(String defaultLayoutName)
	{
		this.defaultLayoutName = defaultLayoutName;
	}

	public void setDefaultPageSize(String defaultPageSize)
	{
		this.defaultPageSize = defaultPageSize;
	}

	public void setDefaultUserForEmployee(Boolean defaultUserForEmployee)
	{
		this.defaultUserForEmployee = defaultUserForEmployee;
	}

	public void setDirectPrint(Boolean directPrint)
	{
		this.directPrint = directPrint;
	}

	public void setDisabledFields(List<DTOSecurityFieldAuthority> disabledFields)
	{
		this.disabledFields = disabledFields;
	}

	public void setDoNotCreatingTroubleTicketReq(Boolean doNotCreatingTroubleTicketReq)
	{
		this.doNotCreatingTroubleTicketReq = doNotCreatingTroubleTicketReq;
	}

	public void setDoNotDisplayCriticalErrors(Boolean doNotDisplayCriticalErrors)
	{
		this.doNotDisplayCriticalErrors = doNotDisplayCriticalErrors;
	}

	public void setDoNotDisplaySystemHelpMsgs(Boolean doNotDisplaySystemHelpMsgs)
	{
		this.doNotDisplaySystemHelpMsgs = doNotDisplaySystemHelpMsgs;
	}

	public void setDoNotUseLDAPForLogin(Boolean doNotUseLDAPForLogin)
	{
		this.doNotUseLDAPForLogin = doNotUseLDAPForLogin;
	}

	public void setDontUseAsFirstAuthor(Boolean dontUseAsFirstAuthor)
	{
		this.dontUseAsFirstAuthor = dontUseAsFirstAuthor;
	}

	public void setEmailPassword(String emailPassword)
	{
		this.emailPassword = emailPassword;
	}

	public void setEmailUsedWithSendAsEmailWindow(String emailUsedWithSendAsEmailWindow)
	{
		this.emailUsedWithSendAsEmailWindow = emailUsedWithSendAsEmailWindow;
	}

	public void setExcludeFrom2FA(Boolean excludeFrom2FA)
	{
		this.excludeFrom2FA = excludeFrom2FA;
	}

	public void setExtraFilters(List<DTOExtraSecurityFilters> extraFilters)
	{
		this.extraFilters = extraFilters;
	}

	public void setFcmDeviceTokens(String fcmDeviceTokens)
	{
		this.fcmDeviceTokens = fcmDeviceTokens;
	}

	public void setFontInfo(DTOFontInfo fontInfo)
	{
		this.fontInfo = fontInfo;
	}

	public void setHijriDate(Boolean hijriDate)
	{
		this.hijriDate = hijriDate;
	}

	public void setHtmlRepZoom(Integer htmlRepZoom)
	{
		this.htmlRepZoom = htmlRepZoom;
	}

	public void setListViewSecurityLines(List<DTOListViewSecurityLine> listViewSecurityLines)
	{
		this.listViewSecurityLines = listViewSecurityLines;
	}

	public void setLoginContext(DTOGenericDimensions loginContext)
	{
		this.loginContext = loginContext;
	}

	public void setLoginDimensions(List<DTOLoginDimensionLine> loginDimensions)
	{
		this.loginDimensions = loginDimensions;
	}

	public void setLoginFromAppsOnly(Boolean loginFromAppsOnly)
	{
		this.loginFromAppsOnly = loginFromAppsOnly;
	}

	public void setMaxExportCount(Integer maxExportCount)
	{
		this.maxExportCount = maxExportCount;
	}

	public void setMaxLoginSessions(Integer maxLoginSessions)
	{
		this.maxLoginSessions = maxLoginSessions;
	}

	public void setMaxNumberToRunReport(Integer maxNumberToRunReport)
	{
		this.maxNumberToRunReport = maxNumberToRunReport;
	}

	public void setMaxRecordsPerPageForListViews(Integer maxRecordsPerPageForListViews)
	{
		this.maxRecordsPerPageForListViews = maxRecordsPerPageForListViews;
	}

	public void setMobile(String mobile)
	{
		this.mobile = mobile;
	}

	public void setMobileAppDashboard(EntityReferenceData mobileAppDashboard)
	{
		this.mobileAppDashboard = mobileAppDashboard;
	}

	public void setMobileAppMenuDefinition(EntityReferenceData mobileAppMenuDefinition)
	{
		this.mobileAppMenuDefinition = mobileAppMenuDefinition;
	}

	public void setNotificationCheckPeriod(DTOTimePeriod notificationCheckPeriod)
	{
		this.notificationCheckPeriod = notificationCheckPeriod;
	}

	public void setNotificationContent(String notificationContent)
	{
		this.notificationContent = notificationContent;
	}

	public void setNotificationsCount(Integer notificationsCount)
	{
		this.notificationsCount = notificationsCount;
	}

	public void setPageSecurity(List<DTOPageSecurity> pageSecurity)
	{
		this.pageSecurity = pageSecurity;
	}

	public void setPasswordMustBeChanged(Boolean passwordMustBeChanged)
	{
		this.passwordMustBeChanged = passwordMustBeChanged;
	}

	public void setPosSecurityProfile(EntityReferenceData posSecurityProfile)
	{
		this.posSecurityProfile = posSecurityProfile;
	}

	public void setPosUser(Boolean posUser)
	{
		this.posUser = posUser;
	}

	public void setPrevUserToRunSameRepMultipleTimes(Boolean prevUserToRunSameRepMultipleTimes)
	{
		this.prevUserToRunSameRepMultipleTimes = prevUserToRunSameRepMultipleTimes;
	}

	public void setPreventEssLogin(Boolean preventEssLogin)
	{
		this.preventEssLogin = preventEssLogin;
	}

	public void setPreventLogin(Boolean preventLogin)
	{
		this.preventLogin = preventLogin;
	}

	public void setPreventModifyContext(Boolean preventModifyContext)
	{
		this.preventModifyContext = preventModifyContext;
	}

	public void setPreventPublicLogin(Boolean preventPublicLogin)
	{
		this.preventPublicLogin = preventPublicLogin;
	}

	public void setPreventedLoginMessage(String preventedLoginMessage)
	{
		this.preventedLoginMessage = preventedLoginMessage;
	}

	public void setPrintDocumentsOnSave(Boolean printDocumentsOnSave)
	{
		this.printDocumentsOnSave = printDocumentsOnSave;
	}

	public void setRelatedEntity(EntityReferenceData relatedEntity)
	{
		this.relatedEntity = relatedEntity;
	}

	public void setResetPasswordRequestedOn(Date resetPasswordRequestedOn)
	{
		this.resetPasswordRequestedOn = resetPasswordRequestedOn;
	}

	public void setResetPasswordToken(String resetPasswordToken)
	{
		this.resetPasswordToken = resetPasswordToken;
	}

	public void setStandardLines(List<DTOUserStandardSecurityLine> standardLines)
	{
		this.standardLines = standardLines;
	}

	public void setTimedQuery(EntityReferenceData timedQuery)
	{
		this.timedQuery = timedQuery;
	}

	public void setTreatAsAdmin(Boolean treatAsAdmin)
	{
		this.treatAsAdmin = treatAsAdmin;
	}

	public void setTreatAsUsersInFirstAuthor(List<DTOTreatAsUsersInFirstAuthorLine> treatAsUsersInFirstAuthor)
	{
		this.treatAsUsersInFirstAuthor = treatAsUsersInFirstAuthor;
	}

	public void setUserLevel(String userLevel)
	{
		this.userLevel = userLevel;
	}

	public void setUsersCounter(EntityReferenceData usersCounter)
	{
		this.usersCounter = usersCounter;
	}

	public void setViewSystemReports(Boolean viewSystemReports)
	{
		this.viewSystemReports = viewSystemReports;
	}

	public void setViewingFormat(String viewingFormat)
	{
		this.viewingFormat = viewingFormat;
	}

}
